/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ShapeUtil {
    public static Paint getGradientForShape(Shape shape, Color color, boolean topDown) {
        Color lighterColor = Color.WHITE;
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        float saturation = 0.3f * hsb[1];
        float brightness = hsb[2] * 1.2f;
        if (brightness > 1.0f) {
            brightness = 1.0f;
        }
        lighterColor = new Color(Color.HSBtoRGB(hsb[0], saturation, brightness), false);
        Rectangle2D outerExtent = shape.getBounds2D();
        return new GradientPaint(new Point2D.Double(outerExtent.getX(), outerExtent.getY() + outerExtent.getHeight()), topDown ? color : lighterColor, new Point2D.Double(outerExtent.getX(), outerExtent.getY()), topDown ? lighterColor : color, false);
    }
}

