/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Color;
import java.awt.Font;
import oracle.diagram.framework.graphic.BodyTextShape;
import oracle.diagram.framework.graphic.ContainerGraphic;
import oracle.diagram.framework.graphic.DerivedShapeOutline;
import oracle.diagram.framework.graphic.FontInterface;
import oracle.diagram.framework.graphic.NoteShapeOutline;
import oracle.diagram.framework.graphic.layout.Anchor;
import oracle.diagram.framework.graphic.layout.Fill;
import oracle.diagram.framework.graphic.layout.ListConstraint;
import oracle.diagram.framework.graphic.layout.ListLayout;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.undo.AbstractUndoableStep;
import oracle.diagram.framework.undo.CompositeUndoableStep;
import oracle.diagram.framework.undo.UndoableStep;
import oracle.diagram.framework.util.TextType;
import oracle.diagram.framework.util.TextUtil;

public class NoteShape
extends ContainerGraphic
implements IlvLabelInterface,
FontInterface {
    public static final String BODY_TEXT = "Body";
    public static final Color DEFAULT_FILL_COLOR = new Color(255, 255, 204);
    public static final Color DEFAULT_LINE_COLOR = new Color(165, 165, 165);
    private DerivedShapeOutline outlinePath;
    private BodyTextShape bodyShape;
    private Color m_fillColor;
    private Color m_lineColor;
    private Color m_fontColor;
    private Font m_font;
    private boolean m_isInitializing;

    public NoteShape(IlvRect r) {
        super(new ListLayout(0.0f, 15.0f, 2.0f, 0.0f));
        SubSelectionManager.setSelectable((IlvGraphic)this, false);
        this.setTopLevel(true);
        this.outlinePath = new NoteShapeOutline(r);
        this.outlinePath.setGradientFillOn(true);
        this.outlinePath.setThickness(1.0f);
        this.addContent(this.outlinePath);
        SubSelectionManager.setSelectable(this.outlinePath, false);
        TextUtil.setTextType((IlvGraphic)this, TextType.HTML_TEXT);
        this.bodyShape = this.createBodyTextShape();
        this.addContent(this.bodyShape, ListConstraint.create(Anchor.CENTER, Fill.BOTH));
        this.bodyShape.setProperty("ThumbnailHidden", Boolean.TRUE);
        this.setShapeFillColor(DEFAULT_FILL_COLOR);
        this.setShapeLineColor(DEFAULT_LINE_COLOR);
    }

    private BodyTextShape createBodyTextShape() {
        BodyTextShape b = new BodyTextShape(TextType.HTML_TEXT, "");
        b.setName(BODY_TEXT);
        SubSelectionManager.setSelectable((IlvGraphic)b, false);
        return b;
    }

    public String getLabel() {
        return this.bodyShape.getText();
    }

    public IlvRect getLabelBBox(IlvTransformer t) {
        return this.bodyShape.getLabelBBox(t);
    }

    public void setLabel(String text) {
        String htmlText = text;
        if (!TextUtil.isHTML(htmlText)) {
            htmlText = TextUtil.convertPlainToHTML(htmlText, this.getFont(), this.getFontColor());
        }
        this.bodyShape.setText(htmlText);
    }

    public boolean supportMultiline() {
        return true;
    }

    public Color getShapeFillColor() {
        return this.m_fillColor;
    }

    public void setShapeFillColor(Color color) {
        this.m_fillColor = color;
        this.outlinePath.setBackground(color);
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font font) {
        if (font != null && !font.equals(this.m_font)) {
            String htmlText;
            this.m_font = font;
            this.bodyShape.setFont(font);
            if (!this.m_isInitializing && TextUtil.isHTML(htmlText = this.bodyShape.getText())) {
                htmlText = TextUtil.changeFontInHTML(htmlText, this.m_font);
                this.internalSetText(htmlText);
            }
        }
    }

    public Color getShapeLineColor() {
        return this.m_lineColor;
    }

    public void setShapeLineColor(Color color) {
        this.m_lineColor = color;
        this.outlinePath.setForeground(color);
    }

    @Override
    public Color getFontColor() {
        return this.m_fontColor;
    }

    @Override
    public void setFontColor(Color color) {
        if (color != null && !color.equals(this.m_fontColor)) {
            String htmlText;
            this.m_fontColor = color;
            this.bodyShape.setFontColor(color);
            if (!this.m_isInitializing && TextUtil.isHTML(htmlText = this.bodyShape.getText())) {
                htmlText = TextUtil.changeFontColorInHTML(htmlText, this.m_fontColor);
                this.internalSetText(htmlText);
            }
        }
    }

    public final void setInitializing(boolean isInitializing) {
        this.m_isInitializing = isInitializing;
    }

    protected void internalSetText(String text) {
        this.bodyShape.setText(text);
    }

    @Override
    public UndoableStep createUndoableStep() {
        CompositeUndoableStep step = new CompositeUndoableStep(true);
        step.addUndoableStep(super.createUndoableStep());
        step.addUndoableStep(new NoteShapeUndoableStep());
        return step;
    }

    private class NoteShapeUndoableStep
    extends AbstractUndoableStep {
        private String _undoText;
        private String _redoText;

        private NoteShapeUndoableStep() {
        }

        @Override
        public void undo() throws Exception {
            NoteShape.this.internalSetText(this._undoText);
        }

        @Override
        public void redo() throws Exception {
            NoteShape.this.internalSetText(this._redoText);
        }

        @Override
        public void storeUndoState() {
            this._undoText = NoteShape.this.bodyShape.getText();
        }

        @Override
        public void storeRedoState() {
            this._redoText = NoteShape.this.bodyShape.getText();
        }
    }
}

