/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvDrawSelection;
import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLayout;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvShapePath;
import ilog.views.svg.IlvSVGGraphicSet;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import oracle.diagram.framework.graphic.FrameworkCompositeGraphic;
import oracle.diagram.framework.transformer.TransformerUtil;

public class IconShape
extends FrameworkCompositeGraphic
implements IlvShapePath {
    private IlvRectangle _definingRect;
    private IlvSVGGraphicSet _svgIcon;
    private IlvText _label;

    public IconShape(IlvRect rect) {
        this.buildShape(rect, null, null);
    }

    public IconShape(IlvRect rect, String url) {
        this.buildShape(rect, url, null);
    }

    public IconShape(IlvRect rect, String url, String label) {
        this.buildShape(rect, url, label);
    }

    public IconShape(IlvInputStream stream) throws IlvReadFileException {
        super(stream);
    }

    public String setURL(String newURL) {
        String oldURL = this._svgIcon.getURL();
        this._svgIcon.setURL(newURL);
        return oldURL;
    }

    public String getURL() {
        return this._svgIcon.getURL();
    }

    private void buildShape(IlvRect rect, String url, String label) {
        IlvAttachmentLayout layout = new IlvAttachmentLayout();
        this.setLayout((IlvLayoutManager)layout);
        this._svgIcon = new IlvSVGGraphicSet();
        if (url != null) {
            this._svgIcon.setURL(url);
        }
        this._label = new IlvText();
        if (label == null) {
            label = "<No Name>";
        }
        this._label.setLabel(label);
        this.setChildren(0, (IlvGraphic)this._svgIcon);
        this.setChildren(1, (IlvGraphic)this._label);
        this.setConstraints(1, new IlvAttachmentConstraint(IlvAttachmentLocation.TopCenter, IlvAttachmentLocation.BottomCenter));
        this.setSelectionType(0);
    }

    public IlvSelection makeSelection() {
        return new IlvDrawSelection((IlvGraphic)this){

            public boolean supportsResize() {
                return false;
            }
        };
    }

    public PathIterator getShapePath(IlvTransformer t) {
        IlvRect r1 = this._svgIcon.boundingBox(t);
        IlvRect r2 = this._label.boundingBox(t);
        GeneralPath path = new GeneralPath((Shape)r1);
        path.append((Shape)r2, false);
        return path.getPathIterator(TransformerUtil.JAVA2D_IDENTITY_TRANSFORMER);
    }
}

