/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvFreeLinkConnector;

public class FakeNode
extends IlvRectangle {
    private static final String FAKE_NODE = "oracle.diagram.framework.graphic.FakeNode";
    private static final String FAKE_NODE_LAYER_NAME = "oracle.diagram.framework.graphic.FakeNode.layer";

    private FakeNode() {
    }

    public FakeNode(IlvInputStream inputStream) throws IlvReadFileException {
        super(inputStream);
    }

    public static FakeNode find(IlvGraphic g, boolean create) {
        IlvGraphicBag bag;
        IlvGraphicBag ilvGraphicBag = bag = g instanceof IlvGrapher ? (IlvGraphicBag)g : g.getGraphicBag();
        while (!(bag instanceof IlvGrapher)) {
            if ((bag = bag.getGraphicBag()) != null) continue;
            return null;
        }
        IlvGrapher grapher = (IlvGrapher)bag;
        FakeNode fn = (FakeNode)((Object)grapher.getProperty(FAKE_NODE));
        if (fn == null && create) {
            fn = new FakeNode();
            fn.setVisible(false);
            new FakeNodeConnector(fn);
            grapher.setProperty(FAKE_NODE, (Object)fn);
        }
        if (fn != null && !grapher.isNode((IlvGraphic)fn)) {
            grapher.addNode((IlvGraphic)fn, FakeNode.findOrCreateFakeNodeLayer(grapher), false);
        }
        return fn;
    }

    private static int findOrCreateFakeNodeLayer(IlvGrapher grapher) {
        IlvManagerLayer layer = grapher.getManagerLayer(FAKE_NODE_LAYER_NAME);
        if (layer == null) {
            int layers = grapher.getLayersCount();
            grapher.addLayer(layers);
            grapher.setLayerName(layers, FAKE_NODE_LAYER_NAME);
            int index = grapher.getLayer(FAKE_NODE_LAYER_NAME);
            grapher.setVisible(index, false, false);
            return index;
        }
        return layer.getIndex();
    }

    public boolean zoomable() {
        return true;
    }

    public static class FakeNodeConnector
    extends IlvFreeLinkConnector {
        public FakeNodeConnector(IlvInputStream is) throws IlvReadFileException {
            super(is);
        }

        private FakeNodeConnector(FakeNode fn) {
            super((IlvGraphic)fn);
        }

        public IlvPoint getConnectionPoint(IlvLinkImage link, boolean origin, IlvTransformer transformer) {
            IlvPoint p = super.getConnectionPoint(link, origin, transformer);
            return p;
        }

        public void connectLink(final IlvLinkImage link, IlvPoint p, final boolean origin, IlvTransformer t) {
            IlvManager manager;
            IlvLinkShapePolicy policy;
            super.connectLink(link, p, origin, t);
            if (link instanceof IlvPolicyAwareLinkImage && (policy = ((IlvPolicyAwareLinkImage)link).getLinkShapePolicy()) != null && (manager = (IlvManager)link.getGraphicBag()) != null) {
                manager.applyToObject((IlvGraphic)link, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        if (origin) {
                            policy.afterFromNodeMoved(link);
                        } else {
                            policy.afterToNodeMoved(link);
                        }
                        policy.afterAny(link);
                    }
                }, null, true);
            }
        }
    }
}

