/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.BlockDrawSelection;
import oracle.diagram.framework.graphic.ContainerGraphic;
import oracle.diagram.framework.graphic.FontInterface;
import oracle.diagram.framework.graphic.GraphicUtils;
import oracle.diagram.framework.graphic.HTMLTextGraphic;
import oracle.diagram.framework.graphic.layout.AbstractLayout;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubShape;
import oracle.diagram.framework.util.TextType;
import oracle.diagram.framework.util.TextUtil;
import oracle.diagram.thumbnail.ThumbnailConstants;

public class BodyTextShape
extends ContainerGraphic
implements IlvFontInterface,
FontInterface,
SubShape {
    private static final float MIN_BODY_HEIGHT = 50.0f;
    private static final float MIN_BODY_WIDTH = 80.0f;
    private static final Insets TEXT_BOX_MARGINS = new Insets(3, 3, 3, 3);
    private IlvText m_text;

    public BodyTextShape(String text) {
        this(TextType.PLAIN_TEXT, text);
        this.setEditable(true);
    }

    public BodyTextShape(TextType type, String text) {
        super(new Layout());
        IlvRectangle hidden = new IlvRectangle(new IlvRect());
        hidden.setVisible(false);
        this.setChildren(0, (IlvGraphic)hidden);
        this.setResizingPolicy(1);
        TextUtil.setTextType((IlvGraphic)this, type);
        this.m_text = type == TextType.HTML_TEXT ? new HTMLTextGraphic(text) : new IlvText(new IlvPoint(), text);
        this.m_text.setWrappingMode((short)1);
        this.m_text.setAntialiasing(true);
        this.m_text.setFractionalMetrics(false);
        this.setChildren(1, (IlvGraphic)this.m_text);
        SubSelectionManager.setSelectable((IlvGraphic)this.m_text, false);
    }

    public String getText() {
        return this.m_text.getLabel();
    }

    public void setText(String text) {
        this.m_text.setLabel(text);
    }

    public IlvSelection makeSelection() {
        return new BlockDrawSelection((IlvGraphic)this);
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        minimum.setSize(80.0f, 50.0f);
        return minimum;
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered) {
        return this.getMinimumSize(prefered);
    }

    public boolean supportMultiline() {
        return true;
    }

    public void setFont(Font font) {
        this.m_text.setFont(font);
    }

    public Font getFont() {
        return this.m_text.getFont();
    }

    @Override
    public void setFontColor(Color color) {
        this.m_text.setForeground(color);
    }

    @Override
    public boolean contains(IlvPoint p, IlvPoint tp, IlvTransformer t) {
        IlvRect r = this.boundingBox();
        return r.contains((Point2D)p);
    }

    public IlvRect getLabelBBox(IlvTransformer t) {
        IlvRect r = this.getChildren(0).boundingBox();
        r.setRect(r.x + (float)BodyTextShape.TEXT_BOX_MARGINS.left, r.y + (float)BodyTextShape.TEXT_BOX_MARGINS.top, Math.max(r.width - (float)BodyTextShape.TEXT_BOX_MARGINS.left - (float)BodyTextShape.TEXT_BOX_MARGINS.right, 0.0f), Math.max(r.height - (float)BodyTextShape.TEXT_BOX_MARGINS.top - (float)BodyTextShape.TEXT_BOX_MARGINS.bottom, 0.0f));
        if (t != null) {
            t.apply(r);
        }
        return r;
    }

    @Override
    protected IlvGraphic getSubShapeImpl(IlvPoint point, IlvTransformer tx) {
        return null;
    }

    @Override
    public void draw(Graphics g, IlvTransformer t) {
        if (g instanceof Graphics2D && Boolean.TRUE.equals(((Graphics2D)g).getRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT))) {
            return;
        }
        Rectangle savedClip = g.getClipBounds();
        IlvRect r = this.getLabelBBox(t);
        g.clipRect((int)r.x, (int)r.y, (int)r.width, (int)r.height - 2);
        super.draw(g, t);
        if (this.m_text instanceof HTMLTextGraphic) {
            IlvRect labelBBox = this.getLabelBBox(null);
            DimensionFloat htmlSize = ((HTMLTextGraphic)this.m_text).getWrappedHMLTextSize(new DimensionFloat());
            if (htmlSize.width > labelBBox.width || htmlSize.height > labelBBox.height) {
                this.drawEllipse(g, t, r, false, true);
            }
        } else if (!r.contains(this.m_text.boundingBox(t))) {
            this.drawEllipse(g, t, r, false, true);
        }
        g.setClip(savedClip.x, savedClip.y, savedClip.width, savedClip.height);
        if (GraphicUtils.isParentSelected((IlvGraphic)this) && !((ContainerGraphic)this.getGraphicBag()).isSubShapeSelected((IlvGraphic)this)) {
            Graphics2D g2 = (Graphics2D)g;
            Paint oldPaint = g2.getPaint();
            Stroke oldStroke = g2.getStroke();
            g2.setColor(this.m_text.getForeground());
            IlvRect bounds = this.getLabelBBox(null);
            bounds.height -= 1.0f;
            AffineTransform savedTransform = null;
            if (!t.isIdentity()) {
                savedTransform = g2.getTransform();
                AffineTransform at = GraphicUtils.createAffineTransform(t);
                g2.transform(at);
            }
            g2.setStroke(GraphicUtils.DOTTED_STROKE);
            g2.draw((Shape)bounds);
            if (savedTransform != null) {
                g2.setTransform(savedTransform);
            }
            g2.setPaint(oldPaint);
            g2.setStroke(oldStroke);
        }
    }

    @Override
    public Color getFontColor() {
        return this.m_text.getForeground();
    }

    private static class Layout
    extends AbstractLayout {
        private Layout() {
        }

        public void layoutGroup(IlvAttachable ilvAttachable) {
            IlvAttachable[] attachables = ilvAttachable.getAttachables();
            IlvRect bounds = attachables[0].getAttachmentBounds();
            IlvAttachableGraphic att = (IlvAttachableGraphic)attachables[1];
            att.move(bounds.x + (float)TEXT_BOX_MARGINS.left, bounds.y + (float)TEXT_BOX_MARGINS.top);
            IlvText text = (IlvText)att.getGraphic();
            if (text instanceof HTMLTextGraphic) {
                float w = Math.max(1.0f, bounds.width - (float)TEXT_BOX_MARGINS.left - (float)TEXT_BOX_MARGINS.right);
                float h = Math.max(1.0f, bounds.height - (float)TEXT_BOX_MARGINS.top - (float)TEXT_BOX_MARGINS.bottom);
                text.setWrappingWidth(w);
                att.resize(new IlvPoint(w, h));
            } else {
                text.setWrappingWidth(Math.max(1.0f, bounds.width - (float)TEXT_BOX_MARGINS.right));
            }
        }
    }
}

