/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.action.handler;

import ilog.views.IlvManagerView;
import oracle.diagram.framework.action.ActionAvailability;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.action.handler.AbstractHandler;
import oracle.diagram.framework.view.ViewUtil;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;

public class ZoomPercentageHandler
extends AbstractHandler
implements ActionAvailability {
    private static final int[] VALID_CMD_IDS = new int[]{Actions.CMD_ZOOM_400_PERCENT, Actions.CMD_ZOOM_200_PERCENT, Actions.CMD_ZOOM_150_PERCENT, Actions.CMD_ZOOM_125_PERCENT, Actions.CMD_ZOOM_100_PERCENT, Actions.CMD_ZOOM_75_PERCENT, Actions.CMD_ZOOM_50_PERCENT, Actions.CMD_ZOOM_40_PERCENT, Actions.CMD_ZOOM_25_PERCENT, Actions.CMD_ZOOM_15_PERCENT, Actions.CMD_ZOOM_10_PERCENT, Actions.CMD_ZOOM_5_PERCENT};
    private static final int[] ZOOM_LEVELS = ViewUtil.ZOOM_PERCENTAGES;

    public boolean handleEvent(IdeAction action, Context context) {
        IlvManagerView view;
        int zoomLevelIndex = this.getZoomLevelIndex(action.getCommandId());
        if (zoomLevelIndex != -1 && (view = this.getManagerView(context)) != null) {
            ViewUtil.zoomPercent(view, ZOOM_LEVELS[zoomLevelIndex], true);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int zoomLevelIndex = this.getZoomLevelIndex(action.getCommandId());
        if (zoomLevelIndex != -1) {
            IlvManagerView view = this.getManagerView(context);
            if (view != null) {
                action.setEnabled(true);
                int scale = ViewUtil.getCurrentPercentageZoom(view);
                action.setState(scale == ZOOM_LEVELS[zoomLevelIndex]);
            }
            return true;
        }
        return false;
    }

    private int getZoomLevelIndex(int cmdId) {
        for (int i = 0; i < VALID_CMD_IDS.length; ++i) {
            if (VALID_CMD_IDS[i] != cmdId) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isAvailable(IdeAction action, Context context) {
        return false;
    }
}

