/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.action.handler;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.action.handler.AbstractHandler;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;

public class InPlaceEditHandler
extends AbstractHandler {
    protected InPlaceEditPlugin getInPlaceEditPlugin(Context context) {
        return this.getPlugin(context, InPlaceEditPlugin.class);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        InPlaceEditPlugin plugin;
        if (action.getCommandId() == Actions.CMD_EDIT_INLINE && (plugin = this.getInPlaceEditPlugin(context)) != null) {
            DiagramContext dc = this.getDiagramContext(context);
            return this.performInPlaceEdit(plugin, dc);
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == Actions.CMD_EDIT_INLINE) {
            InPlaceEditPlugin plugin = this.getInPlaceEditPlugin(context);
            if (plugin != null) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    protected boolean performInPlaceEdit(InPlaceEditPlugin plugin, DiagramContext context) {
        IlvGraphicBag bag;
        IlvManager mgr = context.getManagerView().getManager();
        IlvGraphic mainObj = null;
        IlvGraphic subObj = null;
        IlvGraphic sel = null;
        IlvGraphicEnumeration e = mgr.getSelectedObjects(true);
        if (e.hasMoreElements()) {
            sel = e.nextElement();
            if (e.hasMoreElements()) {
                return false;
            }
        }
        if ((e = SubSelectionManager.getInstance().getSelectedSubObjects(mgr)).hasMoreElements()) {
            if (sel != null) {
                return false;
            }
            sel = e.nextElement();
            if (e.hasMoreElements()) {
                return false;
            }
        }
        if ((bag = sel.getGraphicBag()) instanceof IlvManager && ((IlvManager)bag).isManaged(sel)) {
            mainObj = sel;
            subObj = null;
        } else {
            subObj = sel;
            mainObj = ManagerUtil.getManagedAncestor(subObj);
        }
        return plugin.performInPlaceEdit((IlvManager)mainObj.getGraphicBag(), mainObj, subObj);
    }
}

