/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.action;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.PropertyResolver;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.XMLKeyStrokeContext;
import oracle.ideri.util.BundlePropertyResolver;
import oracle.javatools.util.BundleLoader;

public final class ActionUtil {
    private static final String ACTION_RESOURCE_BUNDLE = "oracle.diagram.res.ActionResource";
    public static final String ACTION_CATEGORY_DIAGRAM = BundleLoader.getBundle((String)"oracle.diagram.res.ActionResource").getString("diagramCategory.text");
    private static final DiagramKeyStrokeContext DIAGRAM_KEYSTROKE_CONTEXT = new DiagramKeyStrokeContext();

    private ActionUtil() {
    }

    static IdeAction findOrCreateLazyAction(int cmdId, String category, String resBaseName) {
        return ActionUtil.findOrCreateLazyAction(cmdId, category, ActionUtil.class.getClassLoader(), ACTION_RESOURCE_BUNDLE, resBaseName);
    }

    static IdeAction findOrCreateLazyRadioAction(int cmdId, String category, String radioGroupName, String resBaseName) {
        return ActionUtil.findOrCreateLazyRadioAction(cmdId, category, radioGroupName, ActionUtil.class.getClassLoader(), ACTION_RESOURCE_BUNDLE, resBaseName);
    }

    public static final KeyStrokeContext getDiagramKeyStrokeContext() {
        return DIAGRAM_KEYSTROKE_CONTEXT;
    }

    public static final void registerDiagramAction(IdeAction action) {
        DIAGRAM_KEYSTROKE_CONTEXT.registerAction(action);
    }

    public static final Collection<IdeAction> getDiagramActions() {
        return Collections.unmodifiableCollection(DIAGRAM_KEYSTROKE_CONTEXT._actions);
    }

    public static IdeAction findOrCreateLazyAction(int cmdId, String category, ClassLoader resLoader, String resBundleClass, String resBaseName) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action == null) {
            return ActionUtil.createLazyAction(cmdId, category, resLoader, resBundleClass, resBaseName);
        }
        return action;
    }

    public static IdeAction findOrCreateLazyRadioAction(int cmdId, String category, String radioGroupName, ClassLoader resLoader, String resBundleClass, String resBaseName) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action == null) {
            action = ActionUtil.createLazyAction(cmdId, category, resLoader, resBundleClass, resBaseName);
            action.putValue("Radio", (Object)Boolean.TRUE);
            action.putValue("RadioGroupName", (Object)radioGroupName);
            ActionUtil.registerDiagramAction(action);
            return action;
        }
        return action;
    }

    private static IdeAction createLazyAction(int cmdId, String category, ClassLoader resLoader, String resBundleClass, String resBaseName) {
        IdeAction action = IdeAction.get((int)cmdId);
        HashMap<String, String> actionToBundle = new HashMap<String, String>();
        actionToBundle.put("SmallIcon", resBaseName + ".icon");
        actionToBundle.put("Name", resBaseName + ".text");
        actionToBundle.put("NoCtxName", resBaseName + ".contextIndependent.text");
        actionToBundle.put("MnemonicKey", resBaseName + ".mnemonic");
        action.addPropertyResolver((PropertyResolver)new BundlePropertyResolver(resBundleClass, resLoader, actionToBundle));
        action.putValue("Category", (Object)category);
        action.setEnabled(false);
        ActionUtil.registerDiagramAction(action);
        return action;
    }

    private static class DiagramKeyStrokeContext
    extends XMLKeyStrokeContext {
        private final Set _actions = new HashSet();

        protected DiagramKeyStrokeContext() {
            super(ACTION_CATEGORY_DIAGRAM);
        }

        public Set getAllActions(boolean bGlobal) {
            if (bGlobal) {
                return new HashSet(this._actions);
            }
            return Collections.EMPTY_SET;
        }

        public void registerAction(IdeAction action) {
            this._actions.add(action);
        }
    }
}

