/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework;

import ilog.views.IlvHandlesSelection;
import ilog.views.IlvManagerView;
import ilog.views.IlvPolyPointsEdition;
import java.awt.Color;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenu;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.core.util.DiagramDTCache;
import oracle.diagram.framework.action.ActionUtil;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.framework.preference.dom.Font2StringConverter;
import oracle.diagram.framework.print.DefaultPageFormat;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.print.PrintManager;
import oracle.ide.view.View;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.BundleLoader;

public class DiagramFrameworkAddin
implements Addin,
IdeListener,
DynamicMenuListener {
    private static final JComponent[] NO_DYNAMIC_MENUS = new JComponent[0];
    private PrintController _controller = null;
    private NotImplementedPrintController _niController = null;
    private static final String PRINT_AREA_MENU_ID = "PrintAreaMenu";

    public void initialize() {
        IdeAction printSetupAction;
        Ide.addIdeListener((IdeListener)this);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/diagram/res/accelerators.xml");
        ToStringManager.registerCustomConverter(Font2StringConverter.class);
        PrintManager.getPrintManager();
        this._controller = new PrintController();
        IdeAction printAction = IdeAction.find((int)16);
        if (printAction != null) {
            printAction.addController((Controller)this._controller);
        }
        if ((printSetupAction = IdeAction.find((int)15)) != null) {
            printSetupAction.addController((Controller)this._controller);
        }
        this._niController = new NotImplementedPrintController();
        Actions.PRINT_PREVIEW.addController((Controller)this._niController);
        Actions.PRINT_SET_PRINT_AREA.addController((Controller)this._niController);
        Actions.PRINT_CLEAR_PRINT_AREA.addController((Controller)this._niController);
        Menubar menubar = Ide.getMenubar();
        JMenu fileMenu = MenuManager.getJMenu((String)"File");
        ResourceBundle rb = BundleLoader.getBundle((String)"oracle.diagram.res.ActionResource");
        JMenu printAreaMenu = menubar.createSubMenu(rb.getString("PrintArea.text"), new Integer(rb.getString("PrintArea.mnemonic").charAt(0)), MenuConstants.WEIGHT_FILE_PAGE_SETUP);
        MenuManager.putJMenu((String)PRINT_AREA_MENU_ID, (JMenu)printAreaMenu);
        printAreaMenu.add(menubar.createMenuItem((ToggleAction)Actions.PRINT_SET_PRINT_AREA));
        printAreaMenu.add(menubar.createMenuItem((ToggleAction)Actions.PRINT_CLEAR_PRINT_AREA));
        menubar.add((Component)printAreaMenu, fileMenu, MenuConstants.SECTION_FILE_PRINT);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)Actions.PRINT_PREVIEW, MenuConstants.WEIGHT_FILE_PAGE_SETUP), fileMenu, MenuConstants.SECTION_FILE_PRINT);
    }

    public void addinsLoaded(IdeEvent e) {
        DefaultPageFormat.getInstance().initialize();
        IlvHandlesSelection.defaultHandleColor = Color.GRAY;
        IlvHandlesSelection.defaultHandleBackgroundColor = Color.WHITE;
        IlvHandlesSelection.defaultHandleShape = 2;
        IlvHandlesSelection.defaultHandleSize = 2.5f;
        IlvPolyPointsEdition.setAddRemovePointModifier((int)64);
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        this.registerDiagramKeyStrokeContext();
        ExitCommand.addShutdownHook((ShutdownHook)new ShutdownHook(){

            public void shutdown() {
                DiagramDTCache.getInstance().save();
            }

            public boolean canShutdown() {
                return true;
            }
        });
    }

    public void registerDiagramKeyStrokeContext() {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        kscr.addContext(ActionUtil.getDiagramKeyStrokeContext());
    }

    public void mainWindowOpened(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    public JComponent[] gatherDynamicActions(Context context) {
        DiagramMainMenuPlugin p;
        IlvManagerView mgrView;
        View view = context.getView();
        if (view instanceof DiagramView && (mgrView = ((DiagramView)view).getActiveManagerView()) != null && (p = PluginUtil.getPlugin(mgrView, DiagramMainMenuPlugin.class)) != null) {
            return p.getDiagramMenuItems(context);
        }
        return NO_DYNAMIC_MENUS;
    }

    private static class NotImplementedPrintController
    extends PrintController {
        private NotImplementedPrintController() {
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (!super.update(action, context)) {
                action.setEnabled(false);
                return true;
            }
            return true;
        }
    }

    private static class PrintController
    implements Controller {
        private PrintController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            Controller vc = this.getViewController(context);
            if (vc != null) {
                try {
                    return vc.handleEvent(action, context);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            Controller vc = this.getViewController(context);
            if (vc != null) {
                try {
                    return vc.update(action, context);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return true;
                }
            }
            return false;
        }

        protected Controller getViewController(Context context) {
            View view = context.getView();
            if (view instanceof DiagramView) {
                Controller c = view.getController();
                return c;
            }
            return null;
        }
    }
}

