/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.manager;

import ilog.views.IlvLayerVisibilityFilter;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import oracle.diagram.core.manager.CoreManagerLayer;
import oracle.diagram.core.manager.ThumbnailViewLayerVisibilityFilter;
import oracle.diagram.core.thumbnail.ThumbnailManagerViewMarker;
import oracle.diagram.thumbnail.ThumbnailConstants;

public class CoreManager
extends IlvManager {
    private static IlvLayerVisibilityFilter THUMBNAIL_FILTER = new ThumbnailViewLayerVisibilityFilter();

    public CoreManager() {
        this.init();
    }

    public CoreManager(IlvInputStream stream) throws IOException, IlvReadFileException {
        super(stream);
        this.init();
    }

    public CoreManager(IlvManager origin) {
        super(origin);
        this.init();
    }

    public CoreManager(int numberOfLayers) {
        super(numberOfLayers);
        this.init();
    }

    public CoreManager(int numberOfLayers, int maxInList) {
        super(numberOfLayers, maxInList);
        this.init();
    }

    public void draw(Graphics graphics, IlvManagerView view) {
        if (view instanceof ThumbnailManagerViewMarker && graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT, Boolean.TRUE);
            super.draw(graphics, view);
        } else {
            super.draw(graphics, view);
        }
    }

    private void init() {
        this.getManagerLayer(this.getLayersCount()).addVisibilityFilter(THUMBNAIL_FILTER);
    }

    protected IlvManagerLayer createManagerLayer(int i) {
        CoreManagerLayer layer = new CoreManagerLayer(30, i);
        return layer;
    }
}

