/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.manager;

import ilog.views.IlvGrapher;
import ilog.views.IlvLayerVisibilityFilter;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import oracle.diagram.core.manager.CoreManagerLayer;
import oracle.diagram.core.manager.ThumbnailViewLayerVisibilityFilter;
import oracle.diagram.core.thumbnail.ThumbnailManagerViewMarker;
import oracle.diagram.thumbnail.ThumbnailConstants;

public class CoreGrapher
extends IlvGrapher {
    private static IlvLayerVisibilityFilter THUMBNAIL_FILTER = new ThumbnailViewLayerVisibilityFilter();

    public CoreGrapher() {
        this.init();
    }

    public CoreGrapher(IlvInputStream stream) throws IOException, IlvReadFileException {
        super(stream);
        this.init();
    }

    public CoreGrapher(IlvGrapher origin) {
        super(origin);
        this.init();
    }

    public CoreGrapher(int numberOfLayers) {
        super(numberOfLayers);
        this.init();
    }

    public CoreGrapher(int numberOfLayers, int maxInList) {
        super(numberOfLayers, maxInList);
        this.init();
    }

    public void draw(Graphics graphics, IlvManagerView view) {
        if (graphics instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)graphics;
            if (view instanceof ThumbnailManagerViewMarker) {
                g2d.setRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT, Boolean.TRUE);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        }
        super.draw(graphics, view);
    }

    private void init() {
        this.getManagerLayer(this.getLayersCount()).addVisibilityFilter(THUMBNAIL_FILTER);
        this.setSizeLimitToDrawSubmanagerContents(30.0f);
    }

    protected IlvManagerLayer createManagerLayer(int i) {
        CoreManagerLayer layer = new CoreManagerLayer(30, i);
        return layer;
    }
}

