/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.editor;

import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.event.ManagerChangedEvent;
import ilog.views.event.ManagerChangedListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerLayerEvent;
import ilog.views.event.ManagerLayerInsertedEvent;
import ilog.views.event.ManagerLayerListener;
import ilog.views.event.ManagerLayerMovedEvent;
import ilog.views.event.ManagerLayerRemovedEvent;
import ilog.views.event.ManagerLayerVisibilityEvent;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.plaf.basic.BasicPanelUI;

public class ScrollableManagerViewPanel
extends JPanel
implements Scrollable {
    private static UI UI = new UI();
    private IlvManagerView _view = null;
    private final ChangeListener _listener = new ChangeListener();

    public ScrollableManagerViewPanel(IlvManagerView view) {
        this._view = view;
        this.setLayout(new BorderLayout());
        this.setBackground(view.getBackground());
        this.add((Component)view, "Center");
        view.setDoubleBuffering(false);
    }

    public final IlvManagerView getManagerView() {
        return this._view;
    }

    protected void updateSize() {
        IlvManagerView view = this.getManagerView();
        IlvRect r = view.computeBBox();
        Dimension size = new Dimension((int)(r.width + 1.5f), (int)(r.height + 1.5f));
        this.setPreferredSize(size);
        this.setSize(size);
    }

    @Override
    protected void addImpl(Component component, Object obj, int i) {
        if (component instanceof IlvManagerView) {
            if (this._view != null && this._view.getParent() == this) {
                this._view.removeTransformerListener((TransformerListener)this._listener);
                this._view.removeManagerChangedListener((ManagerChangedListener)this._listener);
                this._view.getManager().removeManagerContentChangedListener((ManagerContentChangedListener)this._listener);
                this._view.getManager().removeManagerLayerListener((ManagerLayerListener)this._listener);
                this.remove((Component)this._view);
            }
        } else {
            throw new IllegalArgumentException("Can only add an IlvManagerView");
        }
        this._view = (IlvManagerView)component;
        this._view.addTransformerListener((TransformerListener)this._listener);
        this._view.addManagerChangedListener((ManagerChangedListener)this._listener);
        this._view.getManager().addManagerContentChangedListener((ManagerContentChangedListener)this._listener);
        this._view.getManager().addManagerLayerListener((ManagerLayerListener)this._listener);
        this._view.setDoubleBuffering(false);
        this.updateSize();
        super.addImpl(component, obj, i);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public void processManagerViewKeyEvent(KeyEvent keyevent) {
        this.processKeyEvent(keyevent);
    }

    @Override
    public void updateUI() {
        this.setUI(UI);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        IlvManagerView view = this.getManagerView();
        IlvRect r = view.computeBBox();
        Dimension size = new Dimension((int)(r.width + 1.5f), (int)(r.height + 1.5f));
        return size;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return this.getParent().getWidth();
            }
            case 1: {
                return this.getParent().getHeight();
            }
        }
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private static class UI
    extends BasicPanelUI {
        private UI() {
        }

        @Override
        public void update(Graphics g, JComponent c) {
            ScrollableManagerViewPanel panel = (ScrollableManagerViewPanel)c;
            IlvManagerView view = panel.getManagerView();
            if (c.isOpaque() && (view == null || view.isTransparent())) {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            this.paint(g, c);
        }
    }

    private class ChangeListener
    implements TransformerListener,
    ManagerContentChangedListener,
    ManagerLayerListener,
    ManagerChangedListener {
        private ChangeListener() {
        }

        public void managerChanged(ManagerChangedEvent event) {
            if (event.getOldValue() != null) {
                event.getOldValue().removeManagerContentChangedListener((ManagerContentChangedListener)this);
                event.getOldValue().removeManagerLayerListener((ManagerLayerListener)this);
            }
            if (event.getNewValue() != null) {
                event.getNewValue().addManagerContentChangedListener((ManagerContentChangedListener)this);
                event.getNewValue().addManagerLayerListener((ManagerLayerListener)this);
            }
            ScrollableManagerViewPanel.this.updateSize();
        }

        public void transformerChanged(TransformerChangedEvent event) {
            ScrollableManagerViewPanel.this.updateSize();
        }

        public void contentsChanged(ManagerContentChangedEvent event) {
            if (!event.isAdjusting()) {
                ScrollableManagerViewPanel.this.updateSize();
            }
        }

        public void layerInserted(ManagerLayerInsertedEvent event) {
            ScrollableManagerViewPanel.this.updateSize();
        }

        public void layerRemoved(ManagerLayerRemovedEvent event) {
            ScrollableManagerViewPanel.this.updateSize();
        }

        public void layerMoved(ManagerLayerMovedEvent event) {
            ScrollableManagerViewPanel.this.updateSize();
        }

        public void layerChanged(ManagerLayerEvent event) {
            if (event instanceof ManagerLayerVisibilityEvent) {
                ScrollableManagerViewPanel.this.updateSize();
            }
        }
    }
}

