/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.editor;

import ilog.views.IlvManagerView;
import java.awt.Component;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.core.thumbnail.ThumbnailView;
import oracle.diagram.thumbnail.ThumbnailDockable;
import oracle.diagram.thumbnail.ThumbnailViewFactory;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;

public abstract class JViewsEditor
extends Editor
implements DiagramView {
    protected JViewsEditor() {
    }

    public Object getEditorAttribute(String attribute) {
        if ("scrollable".equals(attribute)) {
            return Boolean.FALSE;
        }
        if ("horizontal_scrollbar_policy".equals(attribute)) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(attribute)) {
            return new Integer(21);
        }
        if ("custom_horizontal_scrollbar".equals(attribute)) {
            return this.getHorizontalScrollBar();
        }
        if ("custom_vertical_scrollbar".equals(attribute)) {
            return this.getVerticalScrollBar();
        }
        return super.getEditorAttribute(attribute);
    }

    public void update(Object observed, UpdateMessage change) {
    }

    protected abstract Component getHorizontalScrollBar();

    protected abstract Component getVerticalScrollBar();

    static {
        ThumbnailDockable.registerThumbnailViewFactory(JViewsEditor.class, (ThumbnailViewFactory)new ThumbnailViewFactory(){

            public Component getThumbnailComponent(Editor editor) {
                IlvManagerView view = ((JViewsEditor)editor).getActiveManagerView();
                if (view != null) {
                    ThumbnailView thumb = new ThumbnailView(view);
                    return thumb;
                }
                return null;
            }
        });
    }
}

