/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser;

import java.io.IOException;
import java.sql.Connection;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.schemabrowser.view.SBWindow;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.model.Element;

public class SBController
implements Controller {
    public static final String SHOW_ACTION_CMD = "SchemaBrowser.SHOW_BROWSER";
    static final int SHOW_ACTION_ID = Ide.findOrCreateCmdID((String)"SchemaBrowser.SHOW_BROWSER");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == SHOW_ACTION_ID) {
            Context context2 = this.createInitialBrowserContext(context);
            String string = (String)context2.getProperty("SchemaBrowser.Connection");
            DockStation dockStation = DockStation.getDockStation();
            SBWindow sBWindow = SBWindow.findBrowser(string);
            sBWindow.setContext(context2);
            dockStation.setDockableVisible((Dockable)sBWindow, true);
            dockStation.activateDockable((Dockable)sBWindow);
        }
        return bl;
    }

    private Context createInitialBrowserContext(Context context) {
        Context context2 = new Context();
        Element element = context.getElement();
        String string = null;
        String string2 = null;
        if (element instanceof DatabaseConnection) {
            string = ((DatabaseConnection)element).getQualifiedConnectionName();
        } else if (element instanceof CatalogFolder) {
            CatalogFolder catalogFolder = (CatalogFolder)element;
            string = (String)catalogFolder.getProperty("ConnectionName");
            string2 = (String)catalogFolder.getProperty("CATALOG");
        }
        context2.setProperty("SchemaBrowser.Connection", (Object)string);
        context2.setProperty("SchemaBrowser.CATALOG", string2);
        return context2;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == SHOW_ACTION_ID) {
            bl = true;
            boolean bl2 = false;
            Element element = context.getElement();
            if (element instanceof DatabaseConnection) {
                DatabaseConnection databaseConnection = (DatabaseConnection)element;
                if (databaseConnection.isConnectionOpen()) {
                    String string = databaseConnection.getQualifiedConnectionName();
                    try {
                        ObjectFactory objectFactory = ObjectFactory.getFactory((String)string, (Connection)databaseConnection.getConnection());
                        bl2 = !objectFactory.isSupportsCatalog();
                    }
                    catch (IOException iOException) {
                        ExceptionHandler.handleException((Exception)iOException, (String)string);
                    }
                }
            } else if (element instanceof CatalogFolder) {
                bl2 = true;
            }
            ideAction.setEnabled(bl2);
        }
        return bl;
    }
}

