/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.request;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.border.Border;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debuggee.References;
import oracle.jdevimpl.runner.uidebug.debuggee.Request;

public class ReqHighlight
extends Request
implements ActionListener {
    private Component _component;
    public static final int REQUEST_TYPE = 6;
    private int _highlight_type;
    private static HighLighter _highlighter;

    public ReqHighlight(int nReqID) {
        super(nReqID, 6);
    }

    @Override
    public void readParam(DebugStream stream) throws IOException {
        int componentID = stream.readInt();
        this._component = (Component)References.getInstance().getReferee(componentID);
        this._highlight_type = stream.readInt();
    }

    @Override
    public void doIt() {
        if (this._component != null) {
            switch (this._highlight_type) {
                case 0: {
                    this.whenShow();
                    break;
                }
                case 1: {
                    this.whenHide();
                    break;
                }
                case 2: {
                    this.whenFlash();
                }
            }
        }
    }

    @Override
    public void writeReply(DebugStream stream) throws IOException {
    }

    private HighLighter getHighlighter() {
        if (_highlighter == null) {
            _highlighter = new HighLighter();
        }
        return _highlighter;
    }

    private void whenShow() {
        HighLighter highliter = this.getHighlighter();
        highliter.locate(this._component);
    }

    private void whenHide() {
        HighLighter highliter = this.getHighlighter();
        highliter.hide();
    }

    private void whenFlash() {
        Timer timer = new Timer(2000, this);
        timer.setRepeats(false);
        this.whenShow();
        timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.whenHide();
    }

    static class HighLighter
    extends JWindow {
        private Border _border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());

        HighLighter() {
            JPanel panelRed = new JPanel();
            panelRed.setBackground(Color.red);
            this.getContentPane().add(panelRed);
            this.getRootPane().setBorder(this._border);
        }

        public void locate(Component c) {
            if (c != null && c.isShowing()) {
                Rectangle r = new Rectangle(c.getLocationOnScreen(), c.getSize());
                this.moveTo(r);
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }

        public void moveTo(Rectangle r) {
            Border border = this._border;
            Insets insets = this._border.getBorderInsets(this.getRootPane());
            if (r.width - insets.left - insets.right < 10 || r.height - insets.top - insets.bottom < 10) {
                border = null;
            }
            this.getRootPane().setBorder(border);
            this.setBounds(r);
        }
    }
}

