/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.request;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debuggee.Debuggee;
import oracle.jdevimpl.runner.uidebug.debuggee.References;
import oracle.jdevimpl.runner.uidebug.debuggee.Request;

public class ReqFullTree
extends Request {
    private static final int TX_IMAGE_TYPE = 1;
    public static final int REQUEST_TYPE = 1;
    private boolean _includeImage;

    public ReqFullTree(int nReqID) {
        super(nReqID, 1);
    }

    @Override
    public void readParam(DebugStream stream) throws IOException {
        this._includeImage = stream.readBoolean();
    }

    @Override
    public void doIt() {
    }

    @Override
    public void writeReply(DebugStream stream) throws IOException {
        References.getInstance().pack();
        stream.writeInt(this.getRequestType());
        stream.writeInt(1);
        Window[] roots = Debuggee.getInstance().getRoots().getRoots();
        stream.writeInt(roots.length);
        for (int i = 0; i < roots.length; ++i) {
            Window root = roots[i];
            boolean sendImage = this._includeImage && root.isVisible();
            stream.writeBoolean(sendImage);
            if (sendImage) {
                BufferedImage image = ReqFullTree.getImage(root);
                stream.writeImage(image);
            }
            this.writeComponent(stream, roots[i]);
        }
    }

    private static BufferedImage getImage(Component component) {
        BufferedImage image;
        int width = component.getWidth();
        int height = component.getHeight();
        if (width > 0 && height > 0) {
            image = new BufferedImage(width, height, 1);
            Graphics2D imageGraphics = image.createGraphics();
            try {
                component.paintAll(imageGraphics);
            }
            catch (Exception e) {}
        } else {
            image = new BufferedImage(1, 1, 1);
        }
        return image;
    }

    private void writeComponent(DebugStream stream, Component c) throws IOException {
        int nID = References.getInstance().getReference(c);
        Class<?> cls = c.getClass();
        boolean bVisible = c.isVisible();
        Rectangle rBounds = c.getBounds();
        stream.writeInt(nID);
        stream.writeClass(cls.getName());
        stream.writeBoolean(bVisible);
        stream.writeInt(rBounds.x);
        stream.writeInt(rBounds.y);
        stream.writeInt(rBounds.width);
        stream.writeInt(rBounds.height);
        if (c instanceof Container) {
            Container ctnr = (Container)c;
            int n = ctnr.getComponentCount();
            stream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                Component child = ctnr.getComponent(i);
                this.writeComponent(stream, child);
            }
        } else {
            stream.writeInt(0);
        }
    }
}

