/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debuggee.References;
import oracle.jdevimpl.runner.uidebug.debuggee.Request;
import oracle.jdevimpl.runner.uidebug.debuggee.dynalistener.ListenerFinder;

public class ReqFindObjectListeners
extends Request {
    public static final int REQUEST_TYPE = 9;
    private int _componentID = -1;
    private ArrayList _listeners;

    public ReqFindObjectListeners(int nReqID) {
        super(nReqID, 9);
    }

    @Override
    public void readParam(DebugStream stream) throws IOException {
        this._componentID = stream.readInt();
    }

    @Override
    public void doIt() {
        Object obj = References.getInstance().getReferee(this._componentID);
        this._listeners = ListenerFinder.findObjectListeners(obj);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this._listeners.size(); ++i) {
            Object[] pair = (Object[])this._listeners.get(i);
            String interfaceName = pair[0].toString();
            set.add(interfaceName);
        }
    }

    @Override
    public void writeReply(DebugStream stream) throws IOException {
        stream.writeInt(this.getReqID());
        stream.writeInt(9);
        stream.writeInt(this._listeners.size());
        for (int i = 0; i < this._listeners.size(); ++i) {
            Object[] pair = (Object[])this._listeners.get(i);
            String listenerInterface = (String)pair[0];
            String listeningClass = (String)pair[1];
            stream.writeUTF(listenerInterface);
            stream.writeUTF(listeningClass);
        }
    }
}

