/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.request;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debuggee.References;
import oracle.jdevimpl.runner.uidebug.debuggee.Request;
import oracle.jdevimpl.runner.uidebug.debuggee.dynalistener.ListenerFinder;

public class ReqFindEventTypes
extends Request {
    public static final int REQUEST_TYPE = 8;
    private int _componentID = -1;
    private ArrayList _eventTypes;
    private boolean _includeChildren;

    public ReqFindEventTypes(int nReqID) {
        super(nReqID, 8);
    }

    @Override
    public void readParam(DebugStream stream) throws IOException {
        this._componentID = stream.readInt();
        this._includeChildren = stream.readBoolean();
    }

    @Override
    public void doIt() {
        Object obj = References.getInstance().getReferee(this._componentID);
        if (this._includeChildren) {
            HashSet listenerTypeNames = new HashSet();
            HashSet visitedClasses = new HashSet();
            this.recFindEventTypes(obj, listenerTypeNames, visitedClasses);
            this._eventTypes = new ArrayList(listenerTypeNames);
        } else {
            this._eventTypes = ListenerFinder.findEventTypes(obj.getClass());
        }
        Collections.sort(this._eventTypes);
    }

    private void recFindEventTypes(Object obj, HashSet listenerTypeNames, HashSet visitedClasses) {
        Class<?> objectClass = obj.getClass();
        if (!visitedClasses.contains(objectClass)) {
            ArrayList listeners = ListenerFinder.findEventTypes(objectClass);
            listenerTypeNames.addAll(listeners);
            visitedClasses.add(objectClass);
        }
        if (obj instanceof Container) {
            Container container = (Container)obj;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                this.recFindEventTypes(component, listenerTypeNames, visitedClasses);
            }
        }
    }

    @Override
    public void writeReply(DebugStream stream) throws IOException {
        stream.writeInt(this.getReqID());
        stream.writeInt(8);
        stream.writeInt(this._eventTypes.size());
        for (String listenerTypeName : this._eventTypes) {
            stream.writeUTF(listenerTypeName);
        }
    }
}

