/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class Roots
implements AWTEventListener {
    private ArrayList _roots = new ArrayList();

    public Roots() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        int nEventID = event.getID();
        if (200 <= nEventID && nEventID <= 209) {
            WindowEvent we = (WindowEvent)event;
            Window w = we.getWindow();
            this.addRoot(w);
        }
    }

    public Window[] getRoots() {
        int n = this._roots.size();
        ArrayList<Window> ret = new ArrayList<Window>(n);
        for (int i = 0; i < n; ++i) {
            WeakReference wr = (WeakReference)this._roots.get(i);
            Window w = (Window)wr.get();
            if (w == null) continue;
            ret.add(w);
        }
        return ret.toArray(new Window[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRootPos(Window w) {
        int nRet = -1;
        ArrayList arrayList = this._roots;
        synchronized (arrayList) {
            int n = this._roots.size();
            for (int i = n - 1; i >= 0; --i) {
                WeakReference wr = (WeakReference)this._roots.get(i);
                Window wi = (Window)wr.get();
                if (wi == null) {
                    this._roots.remove(i);
                    continue;
                }
                if (wi != w) continue;
                nRet = i;
                break;
            }
        }
        return nRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoot(Window w) {
        ArrayList arrayList = this._roots;
        synchronized (arrayList) {
            int i = this.getRootPos(w);
            if (i < 0) {
                this._roots.add(new WeakReference<Window>(w));
            }
        }
    }
}

