/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.WeakHashMap;

public class References {
    private static References INSTANCE;
    private int _nNextInsertionPos;
    private ArrayList _list = new ArrayList(100);
    private WeakHashMap _hash = new WeakHashMap();

    private References() {
    }

    public static References getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new References();
        }
        return INSTANCE;
    }

    public int getReference(Object obj) {
        int ret;
        Integer pos = (Integer)this._hash.get(obj);
        if (pos != null) {
            ret = pos;
        } else {
            WeakReference<Object> ref = new WeakReference<Object>(obj);
            ret = this.getNextInsertionPos();
            pos = new Integer(ret);
            this._list.add(ret, ref);
            this._hash.put(obj, pos);
        }
        return ret;
    }

    public Object getReferee(int reference) {
        WeakReference ref;
        Object ret = null;
        if (0 <= reference && reference < this._list.size() && (ref = (WeakReference)this._list.get(reference)) != null) {
            ret = ref.get();
        }
        return ret;
    }

    public void pack() {
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            WeakReference ref = (WeakReference)this._list.get(i);
            if (ref == null || ref.get() != null) continue;
            this._list.set(i, null);
        }
        this._nNextInsertionPos = 0;
    }

    private int getNextInsertionPos() {
        int n = this._list.size();
        while (this._nNextInsertionPos < n && this._list.get(this._nNextInsertionPos) != null) {
            ++this._nNextInsertionPos;
        }
        return this._nNextInsertionPos;
    }
}

