/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.SwingUtilities;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.comm.DebugStreamFactory;
import oracle.jdevimpl.runner.uidebug.debuggee.Request;
import oracle.jdevimpl.runner.uidebug.debuggee.Roots;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqAddListener;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqFindEventTypes;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqFindObjectListeners;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqFullTree;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqHighlight;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqPeriodicUpdate;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqRemoveListener;
import oracle.jdevimpl.runner.uidebug.debuggee.request.ReqVisible;

public class Debuggee
extends Thread {
    private static final String OPT_PORT = "-uidport,";
    private static final String OPT_JAR = "-jar";
    private static final String OPT_SILENT = "-silent";
    private static Debuggee INSTANCE;
    private DebugStream _stream;
    private Roots _roots;

    private Debuggee() {
        super("UI-Debuggee");
        this.setDaemon(true);
    }

    public static void main(String[] args) {
        int usedArgs;
        int port = 4030;
        String mainClassName = null;
        String jarFileName = null;
        boolean silent = false;
        for (usedArgs = 0; usedArgs < args.length; ++usedArgs) {
            String s = args[usedArgs];
            if (s.startsWith(OPT_PORT)) {
                String portValue = s.substring(OPT_PORT.length());
                try {
                    port = Integer.parseInt(portValue);
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid port number: + " + portValue);
                    Debuggee.usage();
                    System.exit(1);
                }
                continue;
            }
            if (s.startsWith(OPT_JAR)) {
                if (++usedArgs >= args.length) {
                    Debuggee.usage();
                    System.exit(1);
                }
                jarFileName = args[usedArgs];
                ++usedArgs;
                break;
            }
            if (s.startsWith(OPT_SILENT)) {
                silent = true;
                continue;
            }
            ++usedArgs;
            mainClassName = s;
            break;
        }
        Method m = null;
        Object[] args2 = new Object[]{};
        try {
            Class<?> mainClass = null;
            if (mainClassName != null) {
                mainClass = Class.forName(mainClassName);
            } else if (jarFileName != null) {
                File theFile = new File(jarFileName);
                JarFile jarFile = new JarFile(theFile);
                Manifest manifest = jarFile.getManifest();
                Attributes mainAttributes = manifest.getMainAttributes();
                String mainJarClass = mainAttributes.getValue("Main-Class");
                URL url = theFile.toURL();
                URL[] urls = new URL[]{url};
                URLClassLoader jarClassLoader = new URLClassLoader(urls);
                mainClass = jarClassLoader.loadClass(mainJarClass);
            }
            if (mainClass == null) {
                Debuggee.usage();
                System.exit(1);
            }
            Debuggee debuggee = Debuggee.getInstance();
            debuggee.startUp(port, silent);
            int newLenght = args.length - usedArgs;
            String[] newArgs = new String[newLenght];
            System.arraycopy(args, usedArgs, newArgs, 0, newLenght);
            Class[] parameterTypes = new Class[]{newArgs.getClass()};
            m = mainClass.getMethod("main", parameterTypes);
            args2 = new Object[]{newArgs};
        }
        catch (Exception e) {
            e.printStackTrace();
            Debuggee.usage();
            System.exit(1);
        }
        try {
            m.invoke(null, args2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void usage() {
        String usageFormat = "Usage: java {0} [-uidport,<port>] <MainClass>";
        String message = MessageFormat.format("Usage: java {0} [-uidport,<port>] <MainClass>", Debuggee.class.getName());
        System.err.println(message);
    }

    public boolean startUp(int port) {
        return this.startUp(port, true);
    }

    public boolean startUp(int port, boolean silent) {
        if (!silent) {
            String msg1 = MessageFormat.format("*** UI Debugger port is {0} ***", new Integer(port));
            String msg2 = "*** Waiting for UI Debugger connection ***";
            System.out.println(msg1);
            System.out.println("*** Waiting for UI Debugger connection ***");
        }
        this._stream = DebugStreamFactory.createServerSocket(port);
        if (this._stream != null) {
            if (!silent) {
                String msg3 = "*** UI Debugger connected ***";
                System.out.println("*** UI Debugger connected ***");
            }
            this._roots = new Roots();
            this.start();
            return true;
        }
        return false;
    }

    public static Debuggee getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Debuggee();
        }
        return INSTANCE;
    }

    public DebugStream getStream() {
        return this._stream;
    }

    @Override
    public void run() {
        try {
            while (true) {
                int nReqID = this._stream.readInt();
                int nReqType = this._stream.readInt();
                final Request req = this.getRequest(nReqType, nReqID);
                if (req == null) continue;
                req.readParam(this._stream);
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        req.doIt();
                        Debuggee.this._stream.beginWriteTransaction();
                        try {
                            req.writeReply(Debuggee.this._stream);
                            Debuggee.this._stream.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            Debuggee.this._stream.endWriteTransaction();
                        }
                    }
                });
            }
        }
        catch (EOFException eofEx) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Request getRequest(int nReqType, int nReqID) {
        Request req;
        switch (nReqType) {
            case 1: {
                req = new ReqFullTree(nReqID);
                break;
            }
            case 2: {
                req = new ReqVisible(nReqID);
                break;
            }
            case 3: {
                req = new ReqAddListener(nReqID);
                break;
            }
            case 4: {
                req = new ReqRemoveListener(nReqID);
                break;
            }
            case 5: {
                req = new ReqPeriodicUpdate(nReqID);
                break;
            }
            case 6: {
                req = new ReqHighlight(nReqID);
                break;
            }
            case 8: {
                req = new ReqFindEventTypes(nReqID);
                break;
            }
            case 9: {
                req = new ReqFindObjectListeners(nReqID);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid request ID: " + nReqType);
            }
        }
        return req;
    }

    public Roots getRoots() {
        return this._roots;
    }

    public void sendFullTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Debuggee.this._sendFullTree();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _sendFullTree() {
        ReqFullTree req = new ReqFullTree(0);
        req.doIt();
        this._stream.beginWriteTransaction();
        try {
            req.writeReply(this._stream);
            this._stream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this._stream.endWriteTransaction();
        }
    }
}

