/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.comm.codec;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import oracle.jdevimpl.runner.uidebug.comm.codec.BufferedImageIOConstants;

public final class BufferedImageWriter
implements BufferedImageIOConstants {
    private static final boolean DEBUG_STATS = false;
    private DataOutputStream _stream;

    public BufferedImageWriter(DataOutputStream stream) {
        this._stream = stream;
    }

    public void write(BufferedImage bi) throws IOException {
        this.writeColorModel(bi.getColorModel());
        this.writeRaster(bi.getRaster());
        this.writeProperties(bi);
    }

    private void writeColorModel(ColorModel colorModel) throws IOException {
        if (colorModel instanceof IndexColorModel) {
            this.write((IndexColorModel)colorModel);
        } else if (colorModel instanceof DirectColorModel) {
            this.write((DirectColorModel)colorModel);
        } else if (colorModel instanceof ComponentColorModel) {
            this.write((ComponentColorModel)colorModel);
        } else {
            throw new UnsupportedOperationException("Unsupported color model: " + colorModel.getClass().getName());
        }
    }

    private void writeRaster(Raster raster) throws IOException {
        this._stream.writeInt(raster.getWidth());
        this._stream.writeInt(raster.getHeight());
        this.writeDataBuffer(raster.getDataBuffer());
        this.writeSampleModel(raster.getSampleModel());
    }

    private void writeDataBuffer(DataBuffer dataBuffer) throws IOException {
        if (dataBuffer instanceof DataBufferByte) {
            this.write((DataBufferByte)dataBuffer);
        } else if (dataBuffer instanceof DataBufferInt) {
            this.write((DataBufferInt)dataBuffer);
        } else if (dataBuffer instanceof DataBufferShort) {
            this.write((DataBufferShort)dataBuffer);
        } else if (dataBuffer instanceof DataBufferUShort) {
            this.write((DataBufferUShort)dataBuffer);
        } else {
            throw new UnsupportedOperationException("Unsupported data buffer: " + dataBuffer.getClass().getName());
        }
    }

    private void writeSampleModel(SampleModel sampleModel) throws IOException {
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            this.write((PixelInterleavedSampleModel)sampleModel);
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            this.write((SinglePixelPackedSampleModel)sampleModel);
        } else {
            throw new UnsupportedOperationException("Unsupported sample model: " + sampleModel.getClass().getName());
        }
    }

    private void write(int[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            this._stream.writeInt(array[i]);
        }
    }

    private void writeCompressed(int[] array) throws IOException {
        long t0 = System.currentTimeMillis();
        boolean wouldBe = false;
        boolean willBe = false;
        boolean identChunks = false;
        boolean diffChunks = false;
        boolean identLen = false;
        boolean diffLen = false;
        int arrayLen = array.length;
        int start = 0;
        while (start < arrayLen) {
            int subLen = this.getIdentical(array, start);
            if (subLen != 0) {
                this.writeIdentical(array, start, subLen);
                start += subLen;
            }
            if ((subLen = this.getDifferent(array, start)) == 0) continue;
            this.writeDifferent(array, start, subLen);
            start += subLen;
        }
    }

    private int getIdentical(int[] array, int start) throws IOException {
        for (int i = start + 1; i < array.length; ++i) {
            if (array[start] == array[i]) continue;
            int ret = i - start;
            if (ret > 1) {
                return ret;
            }
            return 0;
        }
        return array.length - start;
    }

    private int getDifferent(int[] array, int start) throws IOException {
        for (int i = start + 1; i < array.length; ++i) {
            if (array[i] != array[i - 1]) continue;
            int ret = i - start - 1;
            return ret;
        }
        return array.length - start;
    }

    static String toBinaryString(byte b) {
        String s1 = (b & 0x80) == 0 ? "" : "1";
        String s2 = Integer.toBinaryString(b & 0x7F);
        return s1 + s2;
    }

    private void writeCompressedNumber(int n) throws IOException {
        int sgnBit;
        if (n < 0) {
            n = -n;
            sgnBit = 128;
        } else {
            sgnBit = 0;
        }
        int intermediateFirst = n & 0x3F | sgnBit;
        int nextFirst = n >> 6;
        byte bFirst = (byte)(intermediateFirst | (nextFirst == 0 ? 0 : 64));
        n = nextFirst;
        this._stream.writeByte(bFirst);
        while (n != 0) {
            int intermediate = n & 0x7F;
            int next = n >> 7;
            byte b = (byte)(intermediate | (next == 0 ? 0 : 128));
            n = next;
            this._stream.writeByte(b);
        }
    }

    private void writeIdentical(int[] array, int start, int len) throws IOException {
        this.writeCompressedNumber(len);
        this._stream.writeInt(array[start]);
    }

    private void writeDifferent(int[] array, int start, int len) throws IOException {
        this.writeCompressedNumber(-len);
        for (int i = 0; i < len; ++i) {
            this._stream.writeInt(array[start + i]);
        }
    }

    static void printArray(String type, int[] array, int start, int len) {
        System.out.print(type + " " + len + ":");
        for (int i = 0; i < len; ++i) {
            System.out.print(" " + array[start + i]);
        }
        System.out.println("");
    }

    private void write(short[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            this._stream.writeShort(array[i]);
        }
    }

    private void write(IndexColorModel colorModel) throws IOException {
        int mapSize = colorModel.getMapSize();
        int pixelSize = colorModel.getPixelSize();
        byte[] bytes = new byte[mapSize];
        this._stream.write(1);
        this._stream.writeInt(mapSize);
        this._stream.writeInt(pixelSize);
        colorModel.getReds(bytes);
        this._stream.write(bytes);
        colorModel.getGreens(bytes);
        this._stream.write(bytes);
        colorModel.getBlues(bytes);
        this._stream.write(bytes);
    }

    private void write(DirectColorModel colorModel) throws IOException {
        int pixelSize = colorModel.getPixelSize();
        int redMask = colorModel.getRedMask();
        int greenMask = colorModel.getGreenMask();
        int blueMask = colorModel.getBlueMask();
        this._stream.write(2);
        this._stream.writeInt(pixelSize);
        this._stream.writeInt(redMask);
        this._stream.writeInt(greenMask);
        this._stream.writeInt(blueMask);
    }

    private void write(ComponentColorModel colorModel) throws IOException {
        ColorSpace colorSpace = colorModel.getColorSpace();
        int[] componentSize = colorModel.getComponentSize();
        int componentSizeLength = componentSize.length;
        boolean alpha = colorModel.hasAlpha();
        boolean alphaPremultiplied = colorModel.isAlphaPremultiplied();
        int transparency = colorModel.getTransparency();
        int transferType = colorModel.getTransferType();
        this._stream.write(3);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this._stream);
        objectOutputStream.writeObject(colorSpace);
        objectOutputStream.flush();
        this._stream.writeInt(componentSizeLength);
        this.write(componentSize);
        this._stream.writeBoolean(alpha);
        this._stream.writeBoolean(alphaPremultiplied);
        this._stream.writeInt(transparency);
        this._stream.writeInt(transferType);
    }

    private void write(PixelInterleavedSampleModel sampleModel) throws IOException {
        int scanlistStride = sampleModel.getScanlineStride();
        int pixelStride = sampleModel.getPixelStride();
        int[] bandOffsets = sampleModel.getBandOffsets();
        this._stream.write(1);
        this._stream.writeInt(scanlistStride);
        this._stream.writeInt(pixelStride);
        this._stream.writeInt(bandOffsets.length);
        this.write(bandOffsets);
    }

    private void write(SinglePixelPackedSampleModel sampleModel) throws IOException {
        int scanlineStride = sampleModel.getScanlineStride();
        int[] bitMasks = sampleModel.getBitMasks();
        this._stream.write(2);
        this._stream.writeInt(scanlineStride);
        this._stream.writeInt(bitMasks.length);
        this.write(bitMasks);
    }

    private void write(DataBufferByte dataBuffer) throws IOException {
        int numBanks = dataBuffer.getNumBanks();
        int size = dataBuffer.getSize();
        byte[][] data = dataBuffer.getBankData();
        this._stream.write(0);
        this._stream.writeInt(numBanks);
        this._stream.writeInt(size);
        for (int i = 0; i < numBanks; ++i) {
            this._stream.write(data[i]);
        }
    }

    private void write(DataBufferInt dataBuffer) throws IOException {
        int numBanks = dataBuffer.getNumBanks();
        int size = dataBuffer.getSize();
        int[][] data = dataBuffer.getBankData();
        this._stream.write(3);
        this._stream.writeInt(numBanks);
        this._stream.writeInt(size);
        for (int i = 0; i < numBanks; ++i) {
            this.writeCompressed(data[i]);
        }
    }

    private void write(DataBufferShort dataBuffer) throws IOException {
        int numBanks = dataBuffer.getNumBanks();
        int size = dataBuffer.getSize();
        short[][] data = dataBuffer.getBankData();
        this._stream.write(2);
        this._stream.writeInt(numBanks);
        this._stream.writeInt(size);
        for (int i = 0; i < numBanks; ++i) {
            this.write(data[i]);
        }
    }

    private void write(DataBufferUShort dataBuffer) throws IOException {
        int numBanks = dataBuffer.getNumBanks();
        int size = dataBuffer.getSize();
        short[][] data = dataBuffer.getBankData();
        this._stream.write(1);
        this._stream.writeInt(numBanks);
        this._stream.writeInt(size);
        for (int i = 0; i < numBanks; ++i) {
            this.write(data[i]);
        }
    }

    private void writeProperties(BufferedImage bi) throws IOException {
        String[] propertyNames = bi.getPropertyNames();
        if (propertyNames != null) {
            int numProp = propertyNames.length;
            this._stream.writeInt(numProp);
            for (int i = 0; i < numProp; ++i) {
                String propertyName = propertyNames[i];
                Object property = bi.getProperty(propertyName);
                if (property instanceof String) {
                    String s = (String)property;
                    this._stream.write(1);
                    this._stream.writeUTF(s);
                    continue;
                }
                if (property instanceof Integer) {
                    Integer integer = (Integer)property;
                    this._stream.write(2);
                    this._stream.writeInt(integer);
                    continue;
                }
                throw new UnsupportedOperationException("Invalid property type: " + propertyName + " = " + property.getClass().getName());
            }
        } else {
            this._stream.writeInt(0);
        }
    }
}

