/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.util;

import java.net.MalformedURLException;
import java.net.URL;

public class Canonicalizer {
    private static char _sSeparator = System.getProperty("file.separator").charAt(0);

    private Canonicalizer() {
    }

    public static String fixPathname(String string) {
        char c = string.charAt(string.length() - 1);
        if (c == '/' || c == _sSeparator) {
            return string;
        }
        string = string + _sSeparator;
        return string;
    }

    public static String fixSeparators(String string) {
        if (string != null) {
            int n = string.length();
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            for (int i = 0; i < n; ++i) {
                if (cArray[i] != '\\') continue;
                cArray[i] = 47;
            }
            return new String(cArray);
        }
        return "";
    }

    public static String appendFileToPath(String string, String string2) {
        char c;
        String string3 = Canonicalizer.fixSeparators(string);
        String string4 = Canonicalizer.fixSeparators(string2);
        if (string3.length() > 0 && (c = string3.charAt(string3.length() - 1)) != '/') {
            string3 = string3 + '/';
        }
        if (string4.length() > 0 && (c = string4.charAt(0)) == '/') {
            string4 = string4.substring(1);
        }
        return string3 + string4;
    }

    public static URL getAbsoluteURL(String string, String string2) throws MalformedURLException {
        URL uRL = null;
        if (string2 != null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (string != null) {
                    try {
                        uRL = new URL(Canonicalizer.appendFileToPath(string, string2));
                    }
                    catch (MalformedURLException malformedURLException2) {
                        throw new MalformedURLException("Canonicalizer.getAbsoluteURL: cannot resolve URL " + malformedURLException2.getMessage());
                    }
                }
                throw new MalformedURLException("Canonicalizer.getAbsoluteURL: cannot resolve URL " + malformedURLException.getMessage());
            }
        } else {
            throw new MalformedURLException("Canonicalizer.getAbsoluteURL: cannot resolve NULL URL ");
        }
        return uRL;
    }
}

