/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ScrollableResultSetDescriptor;
import sqlj.runtime.profile.ref.CachedStatement;
import sqlj.runtime.profile.ref.ExecuteEventListener;
import sqlj.runtime.profile.ref.RTResultSetJDBC;

public abstract class RTStatementJDBCBase
implements CachedStatement,
RTStatement {
    protected PreparedStatement preparedStmt;
    protected CallableStatement callableStmt;
    private boolean m_executeComplete = false;
    private RTResultSetJDBC m_openResultSet = null;
    private boolean m_isClosed = false;
    private ExecuteEventListener m_executeListener = null;
    private boolean m_inUse;
    protected Map m_typeMap;
    protected EntryInfo m_entryInfo;
    protected Command m_command;
    private int m_batchType = 0;
    private static final int BATCH_TYPE_UNKNOWN = 0;
    private static final int BATCH_TYPE_NO_BATCH = 1;
    private static final int BATCH_TYPE_NO_INPUTS = 2;
    private static final int BATCH_TYPE_DML = 3;
    private JDBCBatchContext m_jdbcBatchContext = null;
    private BatchContext m_batchContext = null;
    private boolean m_isBatch = false;
    public static final int EOC = -23700;
    static final int MAX_FIELD_SIZE = -23701;
    static final int MAX_ROWS = -23702;
    static final int QUERY_TIMEOUT = -23703;
    public static final int FETCH_SIZE = -23704;
    public static final int FETCH_DIRECTION = -23705;
    public static final int REGISTER_OUT = -23710;
    static final int ASCII_STREAM = -23711;
    static final int BINARY_STREAM = -23712;
    static final int UNICODE_STREAM = -23713;
    static final int CHARACTER_STREAM = -23714;

    public RTStatementJDBCBase(PreparedStatement preparedStatement, Connection connection, Map map, EntryInfo entryInfo) {
        this(preparedStatement, connection, true, map, entryInfo);
    }

    public RTStatementJDBCBase(PreparedStatement preparedStatement, Connection connection, BatchContext batchContext, Map map, EntryInfo entryInfo) {
        this(preparedStatement, connection, true, batchContext, map, entryInfo);
    }

    public RTStatementJDBCBase(PreparedStatement preparedStatement, Connection connection, boolean bl, Map map, EntryInfo entryInfo) {
        this.preparedStmt = preparedStatement;
        this.m_inUse = bl;
        this.m_typeMap = map;
        this.m_entryInfo = entryInfo;
        if (preparedStatement == null) {
            this.m_command = new Command(connection);
        }
    }

    public Map getTypeMap() {
        return this.m_typeMap;
    }

    public RTStatementJDBCBase(PreparedStatement preparedStatement, Connection connection, boolean bl, BatchContext batchContext, Map map, EntryInfo entryInfo) {
        this(preparedStatement, connection, bl, map, entryInfo);
        this.m_batchContext = batchContext;
        if (batchContext instanceof JDBCBatchContext) {
            this.m_jdbcBatchContext = (JDBCBatchContext)batchContext;
        }
        this.m_isBatch = true;
    }

    public PreparedStatement getJDBCPreparedStatement() {
        return this.preparedStmt;
    }

    public boolean isBatchable() {
        if (this.m_batchType == 0) {
            if (this.m_entryInfo.getStatementType() == 2 && this.m_entryInfo.getRole() == 3) {
                if (this.m_entryInfo.getParamCount() == 0) {
                    this.m_batchType = 2;
                } else {
                    String string = this.m_entryInfo.getSQLString().trim();
                    while (string.startsWith("/*")) {
                        int n = string.indexOf("*/");
                        string = string.substring(n + 2).trim();
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string2 = "";
                    if (stringTokenizer.hasMoreElements()) {
                        string2 = stringTokenizer.nextToken();
                    }
                    this.m_batchType = string2.equalsIgnoreCase("INSERT") || string2.equalsIgnoreCase("DELETE") || string2.equalsIgnoreCase("UPDATE") ? 3 : 1;
                }
            } else {
                this.m_batchType = 1;
            }
        }
        return this.m_batchType != 1;
    }

    public boolean isBatchCompatible() throws SQLException {
        if (this.m_jdbcBatchContext == null) {
            this.m_jdbcBatchContext = new JDBCBatchContext(this.preparedStmt, this);
            this.m_batchContext = this.m_jdbcBatchContext;
            this.m_isBatch = true;
            return false;
        }
        if (this.m_jdbcBatchContext.isBatchCompatible(this.preparedStmt)) {
            this.m_jdbcBatchContext.addBatch(this.preparedStmt);
            return true;
        }
        this.m_jdbcBatchContext = new JDBCBatchContext(this.preparedStmt, this);
        this.m_batchContext = this.m_jdbcBatchContext;
        this.m_isBatch = true;
        return false;
    }

    public BatchContext getBatchContext() {
        return this.m_batchContext;
    }

    public boolean isBatching() {
        return this.m_isBatch;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.preparedStmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-23701, n);
        } else {
            this.preparedStmt.setMaxFieldSize(n);
        }
    }

    public int getMaxRows() throws SQLException {
        return this.preparedStmt.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-23702, n);
        } else {
            this.preparedStmt.setMaxRows(n);
        }
    }

    public int getQueryTimeout() throws SQLException {
        return this.preparedStmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-23703, n);
        } else {
            this.preparedStmt.setQueryTimeout(n);
        }
    }

    public void cancel() throws SQLException {
        this.preparedStmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.preparedStmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.preparedStmt.clearWarnings();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.m_openResultSet != null) {
            this.m_openResultSet.close();
            this.m_openResultSet = null;
        }
        return this.preparedStmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.preparedStmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.preparedStmt.getMoreResults();
    }

    public RTResultSet executeRTQuery() throws SQLException {
        RTResultSetJDBC rTResultSetJDBC;
        if (this.preparedStmt == null) {
            this.prepareDynamicStatement();
        }
        this.m_openResultSet = rTResultSetJDBC = new RTResultSetJDBC(this.preparedStmt.executeQuery(), this, this.m_typeMap, this.m_entryInfo);
        return rTResultSetJDBC;
    }

    public int executeUpdate() throws SQLException {
        if (this.preparedStmt == null) {
            this.prepareDynamicStatement();
        }
        return this.preparedStmt.executeUpdate();
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-7, n, new Boolean(bl));
        } else {
            this.preparedStmt.setBoolean(n, bl);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-6, n, new Byte(by));
        } else {
            this.preparedStmt.setByte(n, by);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(5, n, new Short(s));
        } else {
            this.preparedStmt.setShort(n, s);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(4, n, new Integer(n2));
        } else {
            this.preparedStmt.setInt(n, n2);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-5, n, new Long(l));
        } else {
            this.preparedStmt.setLong(n, l);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(6, n, new Float(f));
        } else {
            this.preparedStmt.setFloat(n, f);
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(8, n, new Double(d));
        } else {
            this.preparedStmt.setDouble(n, d);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(3, n, bigDecimal);
        } else {
            this.preparedStmt.setBigDecimal(n, bigDecimal);
        }
    }

    public void setString(int n, String string) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(12, n, string);
        } else {
            this.preparedStmt.setString(n, string);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-2, n, byArray);
        } else {
            this.preparedStmt.setBytes(n, byArray);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(2004, n, blob);
        } else {
            this.preparedStmt.setBlob(n, blob);
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(2005, n, clob);
        } else {
            this.preparedStmt.setClob(n, clob);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(2006, n, ref);
        } else {
            this.preparedStmt.setRef(n, ref);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(91, n, date);
        } else {
            this.preparedStmt.setDate(n, date);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(92, n, time);
        } else {
            this.preparedStmt.setTime(n, time);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(93, n, timestamp);
        } else {
            this.preparedStmt.setTimestamp(n, timestamp);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        int n2 = this.m_entryInfo.getParamInfo(n).getSQLType();
        if (n2 == 2002 || n2 == 2001 || n2 == 2000) {
            if (this.preparedStmt == null) {
                this.m_command.set(n2, n, object);
            } else {
                this.preparedStmt.setObject(n, object, n2);
            }
        } else if (this.preparedStmt == null) {
            this.m_command.set(1111, n, object);
        } else {
            this.preparedStmt.setObject(n, object);
        }
    }

    public boolean execute() throws SQLException {
        if (this.preparedStmt == null) {
            this.prepareDynamicStatement();
        }
        return this.preparedStmt.execute();
    }

    public void executeComplete() throws SQLException {
        this.m_executeComplete = true;
        this.checkClose();
    }

    void notifyClosed(RTResultSetJDBC rTResultSetJDBC) throws SQLException {
        this.m_openResultSet = null;
        this.checkClose();
    }

    private void checkClose() throws SQLException {
        if (this.m_executeComplete && this.m_openResultSet == null) {
            if (this.m_executeListener != null) {
                this.m_inUse = false;
                this.m_executeListener.executeCompleted(this);
            } else {
                this.releaseStatement();
            }
        }
    }

    public void setBooleanWrapper(int n, Boolean bl) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-7, n, bl);
        } else if (bl == null) {
            this.preparedStmt.setNull(n, -7);
        } else {
            this.preparedStmt.setBoolean(n, bl);
        }
    }

    public void setByteWrapper(int n, Byte by) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-6, n, by);
        } else if (by == null) {
            this.preparedStmt.setNull(n, -6);
        } else {
            this.preparedStmt.setByte(n, by);
        }
    }

    public void setShortWrapper(int n, Short s) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(5, n, s);
        } else if (s == null) {
            this.preparedStmt.setNull(n, 5);
        } else {
            this.preparedStmt.setShort(n, s);
        }
    }

    public void setIntWrapper(int n, Integer n2) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(4, n, n2);
        } else if (n2 == null) {
            this.preparedStmt.setNull(n, 4);
        } else {
            this.preparedStmt.setInt(n, n2);
        }
    }

    public void setLongWrapper(int n, Long l) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-5, n, l);
        } else if (l == null) {
            this.preparedStmt.setNull(n, -5);
        } else {
            this.preparedStmt.setLong(n, l);
        }
    }

    public void setFloatWrapper(int n, Float f) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(6, n, f);
        } else if (f == null) {
            this.preparedStmt.setNull(n, 6);
        } else {
            this.preparedStmt.setFloat(n, f.floatValue());
        }
    }

    public void setDoubleWrapper(int n, Double d) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(8, n, d);
        } else if (d == null) {
            this.preparedStmt.setNull(n, 8);
        } else {
            this.preparedStmt.setDouble(n, d);
        }
    }

    public void setAsciiStreamWrapper(int n, AsciiStream asciiStream) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-23711, n, asciiStream);
        } else if (asciiStream == null) {
            this.preparedStmt.setNull(n, -1);
        } else {
            this.preparedStmt.setAsciiStream(n, asciiStream.getInputStream(), asciiStream.getLength());
        }
    }

    public void setBinaryStreamWrapper(int n, BinaryStream binaryStream) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-23712, n, binaryStream);
        } else if (binaryStream == null) {
            this.preparedStmt.setNull(n, -4);
        } else {
            this.preparedStmt.setBinaryStream(n, binaryStream.getInputStream(), binaryStream.getLength());
        }
    }

    public void setCharacterStreamWrapper(int n, CharacterStream characterStream) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-23714, n, characterStream);
        } else if (characterStream == null) {
            this.preparedStmt.setNull(n, -1);
        } else {
            this.preparedStmt.setCharacterStream(n, characterStream.getReader(), characterStream.getLength());
        }
    }

    public void setUnicodeStreamWrapper(int n, UnicodeStream unicodeStream) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-23713, n, unicodeStream);
        } else if (unicodeStream == null) {
            this.preparedStmt.setNull(n, -1);
        } else {
            this.preparedStmt.setUnicodeStream(n, unicodeStream.getInputStream(), unicodeStream.getLength());
        }
    }

    public RTStatement getStatement(ExecuteEventListener executeEventListener) throws SQLException {
        if (this.m_isClosed) {
            return null;
        }
        if (this.m_inUse) {
            ProfileRefErrors.raise_STATEMENT_IN_USE();
        }
        if (this.m_executeListener != null) {
            try {
                this.setMaxFieldSize(0);
                this.setMaxRows(0);
                this.setQueryTimeout(0);
                this.clearWarnings();
            }
            catch (SQLException sQLException) {
                this.releaseStatement();
                throw sQLException;
            }
        }
        this.m_executeListener = executeEventListener;
        this.m_inUse = true;
        return this;
    }

    public RTStatement getStatement(ExecuteEventListener executeEventListener, BatchContext batchContext) throws SQLException {
        this.m_batchContext = batchContext;
        this.m_inUse = false;
        return this.getStatement(executeEventListener);
    }

    public void releaseStatement() throws SQLException {
        if (!this.m_isClosed) {
            this.m_isClosed = true;
            this.preparedStmt.close();
        }
    }

    public boolean isReusable() {
        return this.m_entryInfo.getMetaBinds() == null;
    }

    public int getFetchSize() throws SQLException {
        return this.preparedStmt.getFetchSize();
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-23704, n);
        } else {
            this.preparedStmt.setFetchSize(n);
        }
    }

    public int getFetchDirection() throws SQLException {
        return this.preparedStmt.getFetchDirection();
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.preparedStmt == null) {
            this.m_command.set(-23705, n);
        } else {
            this.preparedStmt.setFetchDirection(n);
        }
    }

    public RTStatement prepareDynamicStatement() throws SQLException {
        if (this.preparedStmt == null && this.m_command != null) {
            this.m_command.prepare();
            this.m_command = null;
            return this;
        }
        return null;
    }

    protected class Command {
        private Vector m_commands;
        private StringBuffer m_buffer;
        private int m_xform_pos;
        private Connection m_conn;

        Command(Connection connection) {
            this.m_conn = connection;
            this.m_commands = new Vector();
            this.m_buffer = new StringBuffer();
            this.m_xform_pos = 0;
        }

        void set(int n, int n2) {
            this.m_commands.addElement(new Integer(n));
            this.m_commands.addElement(new Integer(n2));
        }

        void set(int n, int n2, Object object) {
            Object[] objectArray = RTStatementJDBCBase.this.m_entryInfo.getMetaBinds();
            if (objectArray[n2 - 1] == null || objectArray[n2 - 1] instanceof String) {
                int n3 = RTStatementJDBCBase.this.m_entryInfo.getParamInfo(n2).getMarkerIndex();
                this.m_buffer.append(RTStatementJDBCBase.this.m_entryInfo.getSQLString().substring(this.m_xform_pos, n3));
                this.m_buffer.append(object.toString());
                this.m_xform_pos = n3 + 1;
            } else {
                this.m_commands.addElement(new Integer(n));
                this.m_commands.addElement(new Integer((Integer)objectArray[n2 - 1]));
                this.m_commands.addElement(object);
            }
        }

        void prepare() throws SQLException {
            int n;
            Object[] objectArray;
            Class[] classArray;
            Class<?> clazz;
            Object object;
            this.m_buffer.append(RTStatementJDBCBase.this.m_entryInfo.getSQLString().substring(this.m_xform_pos));
            if (RTStatementJDBCBase.this.m_entryInfo.getRole() == 7) {
                object = null;
                try {
                    clazz = Class.forName("oracle.sqlj.checker.OracleSQLParse");
                    classArray = new Class[]{String.class};
                    objectArray = new Object[]{this.m_buffer.toString()};
                    object = (String)clazz.getMethod("addRowid", classArray).invoke(null, objectArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object != null) {
                    this.m_buffer = new StringBuffer((String)object);
                }
            }
            if (RTStatementJDBCBase.this.m_entryInfo.getRole() == 6) {
                object = null;
                try {
                    clazz = Class.forName("oracle.sqlj.checker.OracleSQLParse");
                    classArray = new Class[]{String.class};
                    objectArray = new Object[]{this.m_buffer.toString()};
                    object = (String)clazz.getMethod("replaceWhereCurrentOf", classArray).invoke(null, objectArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_buffer = new StringBuffer((String)object);
            }
            if (RTStatementJDBCBase.this.m_entryInfo.getStatementType() == 2) {
                RTStatementJDBCBase.this.preparedStmt = this.m_conn.prepareStatement(this.m_buffer.toString());
            } else {
                object = RTStatementJDBCBase.this.m_entryInfo.getScrollableDescriptor();
                RTStatementJDBCBase.this.callableStmt = object == null ? this.m_conn.prepareCall(this.m_buffer.toString()) : this.m_conn.prepareCall(this.m_buffer.toString(), ((ScrollableResultSetDescriptor)object).getType(), ((ScrollableResultSetDescriptor)object).getConcurrency());
                RTStatementJDBCBase.this.preparedStmt = RTStatementJDBCBase.this.callableStmt;
            }
            this.m_xform_pos = 0;
            block32: while ((n = this.nextInt()) != -23700) {
                switch (n) {
                    case -23701: {
                        RTStatementJDBCBase.this.preparedStmt.setMaxFieldSize(this.nextInt());
                        continue block32;
                    }
                    case -23702: {
                        RTStatementJDBCBase.this.preparedStmt.setMaxRows(this.nextInt());
                        continue block32;
                    }
                    case -23703: {
                        RTStatementJDBCBase.this.preparedStmt.setQueryTimeout(this.nextInt());
                        continue block32;
                    }
                    case -23710: {
                        RTStatementJDBCBase.this.callableStmt.registerOutParameter(this.nextInt(), this.nextInt());
                        continue block32;
                    }
                    case -7: {
                        RTStatementJDBCBase.this.setBooleanWrapper(this.nextInt(), (Boolean)this.nextObject());
                        continue block32;
                    }
                    case -6: {
                        RTStatementJDBCBase.this.setByteWrapper(this.nextInt(), (Byte)this.nextObject());
                        continue block32;
                    }
                    case 5: {
                        RTStatementJDBCBase.this.setShortWrapper(this.nextInt(), (Short)this.nextObject());
                        continue block32;
                    }
                    case 4: {
                        RTStatementJDBCBase.this.setIntWrapper(this.nextInt(), (Integer)this.nextObject());
                        continue block32;
                    }
                    case -5: {
                        RTStatementJDBCBase.this.setLongWrapper(this.nextInt(), (Long)this.nextObject());
                        continue block32;
                    }
                    case 6: {
                        RTStatementJDBCBase.this.setFloatWrapper(this.nextInt(), (Float)this.nextObject());
                        continue block32;
                    }
                    case 8: {
                        RTStatementJDBCBase.this.setDoubleWrapper(this.nextInt(), (Double)this.nextObject());
                        continue block32;
                    }
                    case -2: {
                        RTStatementJDBCBase.this.preparedStmt.setBytes(this.nextInt(), (byte[])this.nextObject());
                        continue block32;
                    }
                    case 3: {
                        RTStatementJDBCBase.this.preparedStmt.setBigDecimal(this.nextInt(), (BigDecimal)this.nextObject());
                        continue block32;
                    }
                    case 12: {
                        RTStatementJDBCBase.this.preparedStmt.setString(this.nextInt(), (String)this.nextObject());
                        continue block32;
                    }
                    case 91: {
                        RTStatementJDBCBase.this.preparedStmt.setDate(this.nextInt(), (Date)this.nextObject());
                        continue block32;
                    }
                    case 92: {
                        RTStatementJDBCBase.this.preparedStmt.setTime(this.nextInt(), (Time)this.nextObject());
                        continue block32;
                    }
                    case 93: {
                        RTStatementJDBCBase.this.preparedStmt.setTimestamp(this.nextInt(), (Timestamp)this.nextObject());
                        continue block32;
                    }
                    case -23711: {
                        RTStatementJDBCBase.this.setAsciiStreamWrapper(this.nextInt(), (AsciiStream)this.nextObject());
                        continue block32;
                    }
                    case -23712: {
                        RTStatementJDBCBase.this.setBinaryStreamWrapper(this.nextInt(), (BinaryStream)this.nextObject());
                        continue block32;
                    }
                    case -23714: {
                        RTStatementJDBCBase.this.setCharacterStreamWrapper(this.nextInt(), (CharacterStream)this.nextObject());
                        continue block32;
                    }
                    case -23713: {
                        RTStatementJDBCBase.this.setUnicodeStreamWrapper(this.nextInt(), (UnicodeStream)this.nextObject());
                        continue block32;
                    }
                    case -23704: {
                        RTStatementJDBCBase.this.preparedStmt.setFetchSize(this.nextInt());
                        continue block32;
                    }
                    case -23705: {
                        RTStatementJDBCBase.this.preparedStmt.setFetchDirection(this.nextInt());
                        continue block32;
                    }
                    case 2004: {
                        RTStatementJDBCBase.this.preparedStmt.setBlob(this.nextInt(), (Blob)this.nextObject());
                        continue block32;
                    }
                    case 2005: {
                        RTStatementJDBCBase.this.preparedStmt.setClob(this.nextInt(), (Clob)this.nextObject());
                        continue block32;
                    }
                    case 2006: {
                        RTStatementJDBCBase.this.preparedStmt.setRef(this.nextInt(), (Ref)this.nextObject());
                        continue block32;
                    }
                }
                RTStatementJDBCBase.this.preparedStmt.setObject(this.nextInt(), this.nextObject());
            }
        }

        private int nextInt() {
            if (this.m_xform_pos >= this.m_commands.size()) {
                return -23700;
            }
            return (Integer)this.m_commands.elementAt(this.m_xform_pos++);
        }

        private Object nextObject() {
            return this.m_commands.elementAt(this.m_xform_pos++);
        }
    }

    public static class JDBCBatchContext
    implements BatchContext {
        private static final int JDBC_DEFAULT_BATCH_SIZE = 100;
        private static final int UNLIMITED_BATCH_SIZE = Integer.MAX_VALUE;
        private PreparedStatement m_stmt;
        private RTStatementJDBCBase m_rtstmt;
        private int m_batchLimit;
        private int m_count = 0;

        JDBCBatchContext(PreparedStatement preparedStatement, RTStatementJDBCBase rTStatementJDBCBase) throws SQLException {
            this.m_stmt = preparedStatement;
            this.m_rtstmt = rTStatementJDBCBase;
            this.m_batchLimit = Integer.MAX_VALUE;
            this.m_stmt.addBatch();
            ++this.m_count;
        }

        boolean isBatchCompatible(PreparedStatement preparedStatement) {
            return this.m_count < this.m_batchLimit && preparedStatement == this.m_stmt;
        }

        void addBatch(PreparedStatement preparedStatement) throws SQLException {
            if (this.m_count >= this.m_batchLimit) {
                this.executeBatch();
            } else if (this.m_stmt != preparedStatement) {
                throw new SQLException("JDBCBatchContext.addBatch: incompatible Batch");
            }
            ++this.m_count;
            this.m_stmt.addBatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] executeBatch() throws SQLException {
            int[] nArray;
            if (this.m_stmt == null) {
                return null;
            }
            try {
                nArray = this.m_stmt.executeBatch();
            }
            finally {
                this.m_stmt = null;
                this.m_count = 0;
                this.m_rtstmt.m_isBatch = false;
                this.m_rtstmt.executeComplete();
                this.m_rtstmt = null;
            }
            return nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearBatch() throws SQLException {
            try {
                if (this.m_stmt != null) {
                    this.m_stmt.clearBatch();
                }
            }
            finally {
                this.m_stmt = null;
                this.m_count = 0;
                if (this.m_rtstmt != null) {
                    this.m_rtstmt.m_isBatch = false;
                    this.m_rtstmt.executeComplete();
                    this.m_rtstmt = null;
                }
            }
        }

        public void setBatchLimit(int n) throws SQLException {
            if (n == 0) {
                this.m_batchLimit = Integer.MAX_VALUE;
            } else if (n == -1) {
                this.m_batchLimit = 100;
            } else if (Integer.MAX_VALUE < n) {
                this.m_batchLimit = Integer.MAX_VALUE;
            } else if (0 < n) {
                this.m_batchLimit = n;
            } else {
                RuntimeRefErrors.raise_INVALID_BATCH_LIMIT(n);
            }
        }
    }
}

