/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.reflect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jpub.reflect.RObject;
import oracle.jpub.reflect.ServerSideException;
import oracle.sql.CLOB;

public class Server {
    private static Hashtable m_classes = new Hashtable();
    private static Hashtable m_methods = new Hashtable();
    private static Hashtable m_declaredMethods = new Hashtable();
    private static Hashtable m_fields = new Hashtable();
    private static Hashtable m_declaredFields = new Hashtable();
    private static Hashtable m_constructors = new Hashtable();
    private static Hashtable m_declaredConstructors = new Hashtable();
    private static final Class[] m_emptySig;
    private static Class[] m_oneSig;
    private static String[] m_sa;
    public static final int FLAG_RESET = 1;
    public static final int FLAG_DECLARED_ONLY = 2;
    public static final int FLAG_STATIC_ONLY = 4;
    public static final int FLAG_CLASSES_ONLY = 8;
    public static final int FLAG_SERIALIZABLE_ARGUMENTS_ONLY = 16;
    public static final int FLAG_TRANSITIVE_CLOSURE = 32;
    public static final int FLAG_DEBUG = 64;
    private static Connection defaultConnection;
    private static Hashtable m_currentClasses;
    private static Hashtable m_transitiveClasses;
    private static Hashtable m_classesPublished;
    private static boolean m_staticOnly;
    private static boolean m_serializableArgumentsOnly;
    private static boolean m_transitiveClosure;
    private static boolean m_declaredOnly;
    private static boolean m_classesOnly;
    private static Class dbmsJava;
    private static Method classForNameAndSchemaByName;
    private static Method classForNameAndSchemaBySchema;
    private static Field loginSchema;
    private static long m_seq;
    private static long m_base;
    private static Hashtable m_objs;
    private static Hashtable m_tags;
    private static boolean DEBUG;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$oracle$jpub$reflect$Server;

    private Server() {
    }

    public static byte[] invoke(String klass, String name, String sig, byte[] ser_args) throws IOException {
        return Server.invoke(null, klass, name, sig, ser_args);
    }

    public static byte[] invoke(Long handle, String klass, String name, String sig, byte[] ser_args) throws IOException {
        try {
            if (Server.isSys()) {
                return Server.serialize(new Exception("Cannot invoke a method from SYS: "));
            }
            Object o = null;
            if (klass.equals(name) || klass.endsWith("." + name)) {
                Constructor c = Server.getConstructor(klass, sig);
                o = c.newInstance((Object[])Server.deserialize(ser_args));
                o = new Long(Server.registerInstance(o));
            } else {
                Object callee = null;
                if (handle != null) {
                    callee = Server._getInstance(handle);
                }
                Method m = Server.getMethod(klass, name, sig);
                o = m.invoke(callee, (Object[])Server.deserialize(ser_args));
            }
            return Server.serialize(o);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
                t = new ServerSideException(t);
            }
            try {
                return Server.serialize(t);
            }
            catch (IOException e) {
                try {
                    return Server.serialize(new Exception("Unable to serialize exception: " + t.toString()));
                }
                catch (IOException e2) {
                    return null;
                }
            }
        }
    }

    public static byte[] evaluate(byte[] remoteObject) {
        try {
            return Server.serialize(((RObject)Server.deserialize(remoteObject)).evaluate());
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            try {
                return Server.serialize(t);
            }
            catch (IOException e) {
                try {
                    return Server.serialize(new Exception("Unable to serialize exception: " + t.toString()));
                }
                catch (IOException e2) {
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSys() {
        boolean isSys = true;
        Statement s = null;
        ResultSet rs = null;
        try {
            Server.initDefaultConnection(true);
            s = defaultConnection.createStatement();
            String sql = "SELECT count(*) from java$policy$";
            rs = s.executeQuery(sql);
            isSys = true;
        }
        catch (SQLException _) {
            isSys = false;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {}
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return isSys;
    }

    static Constructor getConstructor(String klass, String sig) throws ClassNotFoundException, NoSuchMethodException {
        Constructor m = (Constructor)m_constructors.get(klass + "." + sig);
        if (m == null) {
            Class c = Server.classForName(klass);
            m = c.getConstructor(Server.getSig(sig));
            m_constructors.put(klass + "." + sig, m);
        }
        return m;
    }

    static Method getMethod(String klass, String name, String sig) throws ClassNotFoundException, NoSuchMethodException {
        Method m = (Method)m_methods.get(klass + "." + name + ":" + sig);
        if (m == null) {
            Class c = Server.classForName(klass);
            m = c.getMethod(name, Server.getSig(sig));
            m_methods.put(klass + "." + name + ":" + sig, m);
        }
        return m;
    }

    static Method getDeclaredMethod(String klass, String name, String sig) throws ClassNotFoundException, NoSuchMethodException {
        Method m = (Method)m_declaredMethods.get(klass + "." + name + ":" + sig);
        if (m == null) {
            Class c = Server.classForName(klass);
            m = c.getDeclaredMethod(name, Server.getSig(sig));
            m_declaredMethods.put(klass + "." + name + ":" + sig, m);
        }
        return m;
    }

    static Constructor getDeclaredConstructor(String klass, String sig) throws ClassNotFoundException, NoSuchMethodException {
        Constructor co = (Constructor)m_declaredConstructors.get(klass + ":" + sig);
        if (co == null) {
            Class c = Server.classForName(klass);
            co = c.getDeclaredConstructor(Server.getSig(sig));
            m_declaredConstructors.put(klass + ":" + sig, co);
        }
        return co;
    }

    static Constructor[] getDeclaredConstructors(String klass, boolean debug) throws ClassNotFoundException, NoSuchMethodException {
        Class c = Server.classForName(klass);
        Constructor[] cos = c.getDeclaredConstructors();
        if (debug) {
            System.out.println(klass + " getDeclaredConstructors: " + cos.length);
        }
        for (int i = 0; i < cos.length; ++i) {
            if (Modifier.isPublic(cos[i].getModifiers())) {
                int j;
                if (!m_serializableArgumentsOnly) continue;
                boolean serializable = true;
                Class<?>[] args = cos[i].getParameterTypes();
                for (j = 0; serializable && j < args.length; ++j) {
                    serializable = Server.isSerializable(args[j]);
                }
                if (debug) {
                    System.out.println("constructors: " + i + ", " + serializable + ", " + args.length + ", " + j);
                }
                if (serializable) continue;
                cos[i] = null;
                continue;
            }
            if (debug) {
                System.out.println("constructors: " + i + " not public");
            }
            cos[i] = null;
        }
        return cos;
    }

    static Field getField(String klass, String name) throws ClassNotFoundException, NoSuchFieldException {
        Field f = (Field)m_fields.get(klass + "." + name);
        if (f == null) {
            Class c = Server.classForName(klass);
            f = c.getField(name);
            m_fields.put(klass + "." + name, f);
        }
        return f;
    }

    static Field getDeclaredField(String klass, String name) throws ClassNotFoundException, NoSuchFieldException {
        Field f = (Field)m_declaredFields.get(klass + "." + name);
        if (f == null) {
            Class c = Server.classForName(klass);
            f = c.getDeclaredField(name);
            m_declaredFields.put(klass + "." + name, f);
        }
        return f;
    }

    private static Class[] getSig(String sig) {
        Class c;
        if (sig == null || sig.equals("")) {
            return m_emptySig;
        }
        Server.m_sa[0] = sig;
        if (sig.length() == 1) {
            Server.m_oneSig[0] = Server.getType(m_sa);
            return m_oneSig;
        }
        Vector<Class> v = new Vector<Class>();
        while ((c = Server.getType(m_sa)) != null) {
            v.addElement(c);
        }
        Object[] ca = new Class[v.size()];
        v.copyInto(ca);
        return ca;
    }

    /*
     * Unable to fully structure code
     */
    private static Class getType(String[] sa) {
        idx = 0;
        pos = 0;
        type = null;
        type2 = null;
        if (sa[0] == null || sa[0].equals("")) {
            return null;
        }
        while (sa[0].charAt(idx) == '[') {
            ++idx;
        }
        if (sa[0].charAt(idx) == 'L') {
            try {
                pos = sa[0].indexOf(";");
                if (pos < 0) {
                    type2 = sa[0].substring(idx + 1).replace('/', '.');
                    sa[0] = null;
                } else {
                    type2 = sa[0].substring(idx + 1, pos).replace('/', '.');
                    sa[0] = sa[0].substring(pos + 1);
                }
                type = "L" + type2;
                c = (Class)Server.m_classes.get(type);
                if (c != null) ** GOTO lbl31
                c = Server.classForName(type2);
                Server.m_classes.put(type, c);
            }
            catch (Exception e) {
                throw new NullPointerException();
            }
        } else {
            type = sa[0].substring(idx, idx + 1);
            c = (Class)Server.m_classes.get(type);
            sa[0] = sa[0].substring(idx + 1);
        }
lbl31:
        // 3 sources

        if (idx > 0 && (c = (Class)Server.m_classes.get(idx + type)) == null) {
            c = (Class)Server.m_classes.get(type);
            for (i = 1; i <= idx; ++i) {
                if (Server.m_classes.get(i + type) == null) {
                    c = Array.newInstance(c, 0).getClass();
                    Server.m_classes.put(i + type, c);
                    continue;
                }
                c = (Class)Server.m_classes.get(i + type);
            }
        }
        return c;
    }

    static Object deserialize(byte[] ba) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(ba));
        Object res = null;
        try {
            res = ois.readObject();
            ois.close();
        }
        catch (ClassNotFoundException cnf) {
            try {
                ois.close();
                Class<?> dbmsJava = Class.forName("oracle.aurora.rdbms.ObjectInputStreamWithResolver");
                Constructor<?> c = dbmsJava.getConstructor(class$java$io$InputStream == null ? (class$java$io$InputStream = Server.class$("java.io.InputStream")) : class$java$io$InputStream);
                ois = (ObjectInputStream)c.newInstance(new ByteArrayInputStream(ba));
                res = ois.readObject();
                ois.close();
            }
            catch (Throwable t) {
                throw new IOException(t.getMessage());
            }
        }
        return res;
    }

    static byte[] serialize(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        oos.close();
        byte[] ba = bos.toByteArray();
        return ba;
    }

    public static CLOB reflect2(String nameOrPackage, int flags) {
        CLOB retClob;
        block2: {
            String ret = Server.reflect(nameOrPackage, flags);
            retClob = null;
            try {
                Server.initDefaultConnection(true);
                System.out.println("defaultConnection: " + defaultConnection);
                System.out.println(" oracle.sql.CLOB.DURATION_SESSION: 10");
                retClob = CLOB.createTemporary((Connection)((OracleConnection)defaultConnection), (boolean)false, (int)10);
                Writer writer = retClob.setCharacterStream(0L);
                writer.write(ret.toCharArray());
                writer.flush();
                writer.close();
            }
            catch (Exception se) {
                System.out.println("Error returning server-side refection result");
                if (0 >= (flags & 0x40)) break block2;
                se.printStackTrace();
            }
        }
        return retClob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reflect(String nameOrPackage, int flags) {
        String klass;
        StringBuffer sb = new StringBuffer();
        if (0 < (flags & 0x40)) {
            System.out.println("reflect(" + nameOrPackage + "," + flags + ")");
        }
        if (0 < (flags & 0x40)) {
            sb.append("begin_error reflect(\"" + nameOrPackage + "\"," + flags + ")\nend_error\n");
        }
        StringTokenizer st = new StringTokenizer(nameOrPackage, ",");
        Vector<String> packages = new Vector<String>();
        if (m_classesPublished == null || 0 < (flags & 1)) {
            m_classesPublished = new Hashtable();
        }
        m_currentClasses = new Hashtable();
        m_transitiveClasses = new Hashtable();
        m_transitiveClosure = 0 < (flags & 0x20);
        m_serializableArgumentsOnly = 0 < (flags & 0x10);
        m_classesOnly = 0 < (flags & 8);
        m_declaredOnly = 0 < (flags & 2);
        boolean bl = m_staticOnly = 0 < (flags & 4);
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (name.endsWith(".*")) {
                if (packages.contains(name = name.substring(0, name.length() - 1).replace('.', '/')) || m_classesPublished.get(name) != null) continue;
                packages.addElement(name);
                m_classesPublished.put(name, "");
                continue;
            }
            if (m_currentClasses.get(name) != null || m_classesPublished.get(name) != null) continue;
            m_currentClasses.put(name, "");
        }
        if (packages.size() > 0) {
            String sql = "SELECT DBMS_JAVA.LONGNAME(OBJECT_NAME) FROM USER_OBJECTS WHERE OBJECT_TYPE = 'JAVA CLASS' AND STATUS = 'VALID' AND ";
            if (packages.size() == 1) {
                sql = sql + "DBMS_JAVA.LONGNAME(OBJECT_NAME) LIKE '" + (String)packages.elementAt(0) + "%'";
            } else {
                sql = sql + "(";
                for (int i = 0; i < packages.size(); ++i) {
                    sql = sql + "DBMS_JAVA.LONGNAME(OBJECT_NAME) LIKE '" + (String)packages.elementAt(i) + "%'";
                    if (i >= packages.size() - 1) continue;
                    sql = sql + " OR ";
                }
                sql = sql + ")";
            }
            Statement s = null;
            ResultSet rs = null;
            boolean inServer = false;
            try {
                inServer = Server.initDefaultConnection(inServer);
                if (defaultConnection != null) {
                    if (0 < (flags & 0x40)) {
                        sb.append("begin_error executing: \"" + sql + "\"\nend_error\n");
                    }
                    s = defaultConnection.createStatement();
                    rs = s.executeQuery(sql);
                    while (rs.next()) {
                        String cl = rs.getString(1);
                        int pos = cl.lastIndexOf(47);
                        String pak = 0 <= pos ? cl.substring(0, pos + 1) : "";
                        cl = cl.replace('/', '.').trim();
                        if (0 < (flags & 0x40)) {
                            System.out.println("pak=" + pak + "  cl=" + cl);
                            System.out.println("packages.contains(\"" + pak + "\") = " + packages.contains(pak));
                            System.out.println("m_currentClasses.get(\"" + cl + "\" = " + m_currentClasses.get(cl));
                        }
                        if (!packages.contains(pak) || m_currentClasses.get(cl) != null) continue;
                        if (0 < (flags & 0x40)) {
                            System.out.println("Added class " + cl);
                        }
                        m_currentClasses.put(cl, "");
                    }
                }
            }
            catch (SQLException exn) {
                sb.append("begin_error\n" + exn.toString() + "\ninServer = " + inServer + "\nend_error\n");
                if (0 < (flags & 0x40)) {
                    exn.printStackTrace(System.out);
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2) {}
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException e2) {}
                }
            }
        }
        if (0 < (flags & 0x40)) {
            System.out.println("Info: " + sb.toString());
        }
        Enumeration e = m_currentClasses.keys();
        while (e.hasMoreElements()) {
            klass = (String)e.nextElement();
            Server.reflect(klass, sb, 0 < (flags & 0x40));
        }
        while (m_transitiveClasses.size() > 0) {
            m_currentClasses = m_transitiveClasses;
            m_transitiveClasses = new Hashtable();
            e = m_currentClasses.keys();
            while (e.hasMoreElements()) {
                klass = (String)e.nextElement();
                Server.reflect(klass, sb, 0 < (flags & 0x40));
            }
        }
        return sb.toString();
    }

    private static void reflect(String klass, StringBuffer sb, boolean debug) {
        block48: {
            if (m_transitiveClosure && klass.startsWith("java.") || m_classesPublished.get(klass) != null) {
                if (debug) {
                    sb.append("begin_error skipped class " + klass + "\nend_error\n");
                }
                return;
            }
            m_classesPublished.put(klass, "");
            try {
                int i;
                Class<?>[] itfs;
                Class c = null;
                try {
                    c = Server.classForName(klass);
                }
                catch (ClassNotFoundException exn) {
                    if (klass.indexOf(64) >= 0) {
                        throw exn;
                    }
                    try {
                        c = Server.classForName("java.lang." + klass);
                        klass = "java.lang." + klass;
                    }
                    catch (ClassNotFoundException cnf2) {
                        throw exn;
                    }
                }
                if (debug && c != null) {
                    System.out.println("Continue with: " + c.getName() + ", " + (m_classesOnly && c.isInterface() || !Modifier.isPublic(c.getModifiers())) + "\n");
                }
                if (c == null) {
                    return;
                }
                if (m_classesOnly && c.isInterface()) {
                    return;
                }
                if (!Modifier.isPublic(c.getModifiers())) {
                    return;
                }
                if (c.getName().startsWith("java.lang.") || c.getName().startsWith("java.sql.") || c.getName().startsWith("oracle.sql.") || c.getName().startsWith("oracle.jdbc.")) {
                    return;
                }
                Method[] methods = m_declaredOnly ? c.getDeclaredMethods() : c.getMethods();
                boolean foundAny = false;
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    int modif = methods[i2].getModifiers();
                    if (debug) {
                        System.out.println("methods: " + i2 + ", " + methods[i2].getName() + "," + Modifier.isPublic(modif) + ", " + m_staticOnly + ", " + Modifier.isStatic(modif) + ", " + m_serializableArgumentsOnly + "," + Server.isSerializable(methods[i2].getReturnType()));
                    }
                    if (Modifier.isPublic(modif) && (!m_staticOnly || Modifier.isStatic(modif))) {
                        if (m_serializableArgumentsOnly) {
                            int j;
                            boolean serializable = Server.isSerializable(methods[i2].getReturnType());
                            Class<?>[] args = methods[i2].getParameterTypes();
                            for (j = 0; serializable && j < args.length; ++j) {
                                serializable = Server.isSerializable(args[j]);
                            }
                            if (debug) {
                                System.out.println("methods: " + i2 + ", " + serializable + ", " + args.length + ", " + j);
                            }
                            if (serializable) {
                                foundAny = true;
                                continue;
                            }
                            methods[i2] = null;
                            continue;
                        }
                        foundAny = true;
                        continue;
                    }
                    methods[i2] = null;
                }
                if (debug) {
                    System.out.println("foundAny: " + foundAny + ", " + methods.length + ", " + m_serializableArgumentsOnly);
                }
                if (!foundAny) {
                    return;
                }
                if (c.isInterface()) {
                    sb.append("interface " + klass + "\n");
                } else {
                    sb.append("class " + klass + "\n");
                }
                if (c.getSuperclass() != null && c.getSuperclass() != (class$java$lang$Object == null ? (class$java$lang$Object = Server.class$("java.lang.Object")) : class$java$lang$Object)) {
                    if (m_transitiveClosure) {
                        Server.checkTransitive(c.getSuperclass());
                    }
                    sb.append("extends " + Server.printClass(c.getSuperclass()) + "\n");
                }
                if ((itfs = c.getInterfaces()).length > 0) {
                    sb.append("implements ");
                    for (i = 0; i < itfs.length; ++i) {
                        if (m_transitiveClosure) {
                            Server.checkTransitive(itfs[i]);
                        }
                        sb.append(Server.printClass(itfs[i]));
                        if (i >= itfs.length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("\n");
                }
                for (i = 0; i < methods.length; ++i) {
                    Class<?>[] throws_;
                    if (methods[i] == null) continue;
                    if (!Modifier.isStatic(methods[i].getModifiers())) {
                        sb.append("*");
                    }
                    sb.append(methods[i].getName());
                    sb.append("(");
                    Class<?>[] args = methods[i].getParameterTypes();
                    for (int j = 0; j < args.length; ++j) {
                        if (m_transitiveClosure) {
                            Server.checkTransitive(args[j]);
                        }
                        sb.append(Server.printClass(args[j]));
                        if (j >= args.length - 1) continue;
                        sb.append(",");
                    }
                    sb.append(")");
                    if (methods[i].getReturnType() != Void.TYPE) {
                        if (m_transitiveClosure) {
                            Server.checkTransitive(methods[i].getReturnType());
                        }
                        sb.append(Server.printClass(methods[i].getReturnType()));
                    }
                    if ((throws_ = methods[i].getExceptionTypes()).length > 0) {
                        sb.append(" throws ");
                        for (int j = 0; j < throws_.length; ++j) {
                            if (m_transitiveClosure) {
                                Server.checkTransitive(throws_[j]);
                            }
                            sb.append(Server.printClass(throws_[j]));
                            if (j >= throws_.length - 1) continue;
                            sb.append(",");
                        }
                    }
                    sb.append("\n");
                }
                Constructor[] cos = Server.getDeclaredConstructors(klass, debug);
                for (int i3 = 0; i3 < cos.length; ++i3) {
                    if (cos[i3] == null) continue;
                    if (klass.indexOf(".") > -1) {
                        sb.append(klass.substring(klass.lastIndexOf(".") + 1));
                    } else {
                        sb.append(klass);
                    }
                    sb.append("(");
                    Class<?>[] args = cos[i3].getParameterTypes();
                    for (int j = 0; j < args.length; ++j) {
                        if (m_transitiveClosure) {
                            Server.checkTransitive(args[j]);
                        }
                        sb.append(Server.printClass(args[j]));
                        if (j >= args.length - 1) continue;
                        sb.append(",");
                    }
                    sb.append(")");
                    Class<?>[] throws_ = cos[i3].getExceptionTypes();
                    if (throws_.length > 0) {
                        sb.append(" throws ");
                        for (int j = 0; j < throws_.length; ++j) {
                            if (m_transitiveClosure) {
                                Server.checkTransitive(throws_[j]);
                            }
                            sb.append(Server.printClass(throws_[j]));
                            if (j >= throws_.length - 1) continue;
                            sb.append(",");
                        }
                    }
                    sb.append("\n");
                }
            }
            catch (Throwable t) {
                sb.append("begin_error class for name error: " + klass + "\n" + t + "\nend_error\n");
                if (!debug) break block48;
                t.printStackTrace(System.out);
            }
        }
        if (debug) {
            System.out.println("reflect sb=" + sb.toString());
        }
    }

    private static void checkTransitive(Class c) {
        if (c.isPrimitive()) {
            return;
        }
        if (c.isArray()) {
            Server.checkTransitive(c.getComponentType());
            return;
        }
        String n = c.getName();
        if (n.startsWith("java.") || m_classesPublished.get(n) != null || m_currentClasses.get(n) != null || m_transitiveClasses.get(n) != null) {
            return;
        }
        m_transitiveClasses.put(n, "");
    }

    private static boolean isSerializable(Class c) {
        return c.isArray() ? Server.isSerializable(c.getComponentType()) : (c.isPrimitive() ? true : (class$java$io$Serializable == null ? (class$java$io$Serializable = Server.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(c));
    }

    private static String printClass(Class c) {
        return c.isArray() ? Server.printClass(c.getComponentType()) + "[]" : c.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class classForName(String classString) throws ClassNotFoundException {
        Class theClass;
        block44: {
            int delim;
            theClass = null;
            if (dbmsJava == null) {
                dbmsJava = Class.forName("oracle.aurora.rdbms.DbmsJava");
            }
            String klass = classString;
            if (DEBUG) {
                System.out.println("[Server] classForName: klass=" + klass);
            }
            if ((delim = klass.indexOf(58)) >= 0) {
                klass = klass.substring(0, delim);
            }
            delim = klass.indexOf(64);
            try {
                if (delim >= 0) {
                    try {
                        if (classForNameAndSchemaByName == null) {
                            classForNameAndSchemaByName = dbmsJava.getMethod("classForNameAndSchema", class$java$lang$String == null ? (class$java$lang$String = Server.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Server.class$("java.lang.String")) : class$java$lang$String);
                        }
                        Object[] parameters = new Object[]{klass.substring(0, delim), klass.substring(delim + 1)};
                        theClass = (Class)classForNameAndSchemaByName.invoke(null, parameters);
                        break block44;
                    }
                    catch (Exception e) {
                        throw new ClassNotFoundException("Lookup in schema failed: " + e.toString());
                    }
                }
                try {
                    if (classForNameAndSchemaBySchema == null) {
                        Class<?> dbmsRealm = Class.forName("oracle.aurora.rdbms.DbmsRealm");
                        loginSchema = dbmsRealm.getField("theLoginSchema");
                        Class[] classes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Server.class$("java.lang.String")) : class$java$lang$String, Class.forName("oracle.aurora.rdbms.Schema")};
                        classForNameAndSchemaBySchema = dbmsJava.getMethod("classForNameAndSchema", classes);
                    }
                    if (DEBUG) {
                        System.out.println("[Server] classForName: loginSchema=" + loginSchema);
                    }
                    Object[] parameters = new Object[]{klass, loginSchema.get(null)};
                    theClass = (Class)classForNameAndSchemaBySchema.invoke(null, parameters);
                    if (DEBUG) {
                        System.out.println("[Server] classForName: theClass=" + theClass);
                    }
                }
                catch (Throwable e) {
                    try {
                        if (DEBUG) {
                            System.out.println("[Server] classForName: Class.forName(" + klass + ")");
                        }
                        theClass = Class.forName(klass);
                    }
                    catch (ClassNotFoundException e1) {
                        if (DEBUG) {
                            System.out.println("[Server] classForName: Cannot find" + klass);
                        }
                        throw e1;
                    }
                }
            }
            catch (ClassNotFoundException cnf) {
                ResultSet rs = null;
                Statement s = null;
                try {
                    Server.initDefaultConnection(true);
                    s = defaultConnection.createStatement();
                    String sql = "SELECT OWNER FROM ALL_OBJECTS WHERE DBMS_JAVA.LONGNAME(OBJECT_NAME)='" + klass.replace('.', '/') + "' AND OBJECT_TYPE='JAVA CLASS' AND STATUS='VALID'";
                    rs = s.executeQuery(sql);
                    if (DEBUG) {
                        System.out.println("[Server] look up an owner <" + sql + "> from schema " + ((OracleConnection)defaultConnection).getUserName());
                    }
                    while (rs.next()) {
                        try {
                            String schema = rs.getString(1);
                            if (DEBUG) {
                                System.out.println("[Server] classForName: Check schema <" + schema + ">");
                            }
                            Class<?> dbmsJava = Class.forName("oracle.aurora.rdbms.DbmsJava");
                            Method m = dbmsJava.getMethod("classForNameAndSchema", class$java$lang$String == null ? Server.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? Server.class$("java.lang.String") : class$java$lang$String);
                            theClass = (Class)m.invoke(dbmsJava, klass, schema);
                            if (DEBUG) {
                                System.out.println("[Server] classForName: Get class <" + theClass + ">");
                            }
                            if (theClass == null) continue;
                            break;
                        }
                        catch (Throwable t) {
                            if (!DEBUG) continue;
                            t.printStackTrace();
                        }
                    }
                    if (theClass == null) {
                        throw new NullPointerException("Reflecting Class " + theClass + " as user class returns null");
                    }
                }
                catch (Exception exn2) {
                    new ClassNotFoundException(exn2.toString());
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {}
                    }
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (SQLException e2) {}
                    }
                }
            }
        }
        return theClass;
    }

    private static boolean initDefaultConnection(boolean inServer) throws SQLException {
        if (defaultConnection == null) {
            try {
                defaultConnection = new OracleDriver().defaultConnection();
                if (defaultConnection == null) {
                    throw new NullPointerException("DefaultConnection is null.");
                }
                inServer = true;
            }
            catch (NullPointerException exn) {
                Properties up = new Properties();
                up.put("user", "SYS");
                up.put("password", "X");
                up.put("internal_logon", "sysdba");
                defaultConnection = DriverManager.getConnection("jdbc:oracle:oci:@", up);
            }
        }
        return inServer;
    }

    public static void main(String[] args) {
        int flag = 67;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                flag = Integer.parseInt(args[i].substring(1));
                continue;
            }
            System.out.println(Server.reflect(args[i], flag));
        }
    }

    public static Object _getInstance(long handle) {
        if (handle <= m_base || handle > m_seq) {
            return null;
        }
        return m_objs.get(new Long(handle));
    }

    public static long _setInstance(Object x) {
        if (x == null) {
            return m_base;
        }
        Long l = (Long)m_tags.get(x);
        if (l != null) {
            return l;
        }
        return Server.registerInstance(x);
    }

    public static long registerInstance(Object x) {
        Long l = new Long(++m_seq);
        m_objs.put(l, x);
        m_tags.put(x, l);
        return m_seq;
    }

    public static void releaseInstance(long handle) {
        if (handle <= m_base || handle > m_seq) {
            return;
        }
        Long l = new Long(handle);
        m_objs.remove(l);
        Object x = m_objs.get(l);
        if (x != null) {
            m_tags.remove(x);
        }
    }

    public static void releaseAllInstances() {
        m_objs.clear();
        m_tags.clear();
        m_seq = m_base;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_classes.put("V", Void.TYPE);
        m_classes.put("Z", Boolean.TYPE);
        m_classes.put("B", Byte.TYPE);
        m_classes.put("S", Short.TYPE);
        m_classes.put("I", Integer.TYPE);
        m_classes.put("J", Long.TYPE);
        m_classes.put("D", Double.TYPE);
        m_classes.put("F", Float.TYPE);
        m_classes.put("1Z", Array.newInstance(Boolean.TYPE, 0).getClass());
        m_classes.put("1B", Array.newInstance(Byte.TYPE, 0).getClass());
        m_classes.put("1S", Array.newInstance(Short.TYPE, 0).getClass());
        m_classes.put("1I", Array.newInstance(Integer.TYPE, 0).getClass());
        m_classes.put("1J", Array.newInstance(Long.TYPE, 0).getClass());
        m_classes.put("1D", Array.newInstance(Double.TYPE, 0).getClass());
        m_classes.put("1F", Array.newInstance(Float.TYPE, 0).getClass());
        m_emptySig = new Class[0];
        m_oneSig = new Class[]{Integer.TYPE};
        m_sa = new String[]{""};
        defaultConnection = null;
        m_currentClasses = null;
        m_transitiveClasses = null;
        m_classesPublished = null;
        m_staticOnly = false;
        m_serializableArgumentsOnly = false;
        m_transitiveClosure = false;
        m_declaredOnly = false;
        m_classesOnly = false;
        dbmsJava = null;
        classForNameAndSchemaByName = null;
        classForNameAndSchemaBySchema = null;
        loginSchema = null;
        m_objs = new Hashtable();
        m_tags = new Hashtable();
        m_base = (class$oracle$jpub$reflect$Server == null ? (class$oracle$jpub$reflect$Server = Server.class$("oracle.jpub.reflect.Server")) : class$oracle$jpub$reflect$Server).hashCode();
        m_seq = m_base = m_base > 0L ? -m_base : m_base;
        DEBUG = true;
    }
}

