/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.validators;

import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.validators.IndexValidator;

public class TTIndexValidator
extends IndexValidator {
    public TTIndexValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected void checkColumnExpressions(Index index) throws ValidationException {
        boolean bl = false;
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        Table table = index.getTable();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < indexObjectArray.length; ++i) {
            String string;
            SQLFragment sQLFragment = indexObjectArray[i].getExpression();
            if (sQLFragment instanceof ColumnUsage) {
                ((ColumnUsage)sQLFragment).setProvider(this.getProvider());
            }
            if (table.getColumn(string = this.getProvider().getInternalName(sQLFragment.getSQLText())) != null && (bl || indexObjectArray[i].getOrder() != "DESC")) {
                if (hashSet.contains(string)) {
                    throw new ValidationException((DBObject)index, DBArb.getString((int)133));
                }
                hashSet.add(string);
            }
            this.validateColumnExpression(index, sQLFragment);
        }
    }

    private void validateColumnExpression(Index index, SQLFragment sQLFragment) throws ValidationException {
        boolean bl;
        Table table = index.getTable();
        boolean bl2 = bl = table instanceof MaterializedView && table.getColumns().length == 0;
        if (!bl) {
            try {
                for (String[] stringArray : ParserUtils.getColumnNames((String)sQLFragment.getSQLText(), (ParserUtils.ExpressionType)ParserUtils.ExpressionType.ARITHMETIC)) {
                    String string = this.getProvider().getInternalName(stringArray[0]);
                    Column column = table.getColumn(string);
                    if (column == null) {
                        throw new ValidationException((DBObject)index, DBArb.format((int)127, (Object)string, (Object)table.getName()));
                    }
                    this.validateColumnType(index, column);
                }
            }
            catch (SQLQueryException sQLQueryException) {
                throw new ValidationException((DBObject)index, DBArb.format((int)131, (Object[])new Object[]{index.getName(), sQLFragment}));
            }
        }
    }

    protected void validateNameInUse(Index index) throws NameInUseException {
    }
}

