/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import oracle.dbtools.raptor.controls.IProgressFeedback;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsJTable;
import oracle.dbtools.raptor.timesten.editors.TimesTenViewerContextMenu;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;

abstract class TTTableViewer
extends ViewerEditor {
    static TTTableViewer _lastViewerUpdated = null;
    protected BasicEditorPane _code;
    protected DBObject _lastdbObject;
    protected DBObject _dbObject;
    protected IdeAction _refreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");
    private static final Logger __logger = Logger.getLogger(TTTableViewer.class.getPackage().getName());
    protected JTable _table;

    TTTableViewer() {
    }

    protected abstract String GetPurposeTxt();

    protected void createTable() {
        this._table = new JTable();
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(false);
        this._table.setColumnSelectionAllowed(false);
        this.postCreateHook();
    }

    protected void postCreateHook() {
        this._table.setAutoResizeMode(0);
        TimesTenViewerContextMenu.attachMenu(this._table);
    }

    protected abstract void createTableModel() throws Exception;

    protected JComponent createViewerUI() {
        this.createTable();
        JScrollPane jScrollPane = new JScrollPane(this._table, 22, 32);
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)"Refresh", null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                TTTableViewer.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
        ((Toolbar)super.getFixedTopMargin()).add((ToggleAction)this._refreshAction.newLocalAction((View)this));
        return jScrollPane;
    }

    protected String getBinds() {
        return null;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    protected void updateContent(boolean bl) {
        __logger.log(Level.INFO, this.GetPurposeTxt() + " updateContent: " + bl);
        if (!bl) {
            _lastViewerUpdated = this;
            __logger.log(Level.INFO, "_lastViewerUpdated: " + (Object)((Object)_lastViewerUpdated));
        } else if (_lastViewerUpdated != null && _lastViewerUpdated != this) {
            TTTableViewer.forceUpdateLastViewer();
        }
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode != null) {
            this._dbObject = viewerNode.getDBObject();
        }
        if (bl || this._dbObject != null && (this._lastdbObject == null || this._lastdbObject.getObjectName() != this._dbObject.getObjectName())) {
            ProgressRunnable progressRunnable = new ProgressRunnable(){

                protected void doCancel() {
                    __logger.log(Level.INFO, TTTableViewer.this.GetPurposeTxt() + " cancelled");
                    super.doCancel();
                }

                protected Object doWork() throws Exception {
                    TTTableViewer.this.createTableModel();
                    return Boolean.TRUE;
                }

                protected void finish(Object object) {
                }
            };
            IProgressFeedback iProgressFeedback = new IProgressFeedback(){

                public void feedback(String string) {
                    Log.status((String)string);
                }
            };
            progressRunnable.setTitle(Messages.getString("TTTableViewer.generating") + this.GetPurposeTxt() + "...");
            progressRunnable.setCancelable(true);
            try {
                progressRunnable.start(true);
            }
            catch (ProgressException progressException) {
                // empty catch block
            }
            this._lastdbObject = this._dbObject;
            CGCTableColsJTable.initColumnWidth(this._table, true);
        }
    }

    public static boolean forceUpdateLastViewer() {
        __logger.log(Level.INFO, "forceUpdateLastViewer: " + (Object)((Object)_lastViewerUpdated));
        try {
            _lastViewerUpdated.updateContent(true);
        }
        catch (Exception exception) {
            __logger.log(Level.WARNING, "forceUpdateLastViewer failed");
            return false;
        }
        return true;
    }

    public Object getPrintable() {
        return this._table;
    }

    protected void cleanUp() {
    }

    public Object getEditorAttribute(String string) {
        boolean bl = false;
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }
}

