/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.table.DDLViewer;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.commands.TTSchema;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.editor.BasicEditorPane;

public class TTSchemaSQLTab
extends DDLViewer {
    private static Logger theLogger = Logger.getLogger(TTSchemaSQLTab.class.getPackage().getName());

    protected void updateContent(boolean bl) {
        ViewerNode viewerNode;
        if (bl) {
            TTTableViewer.forceUpdateLastViewer();
        }
        if ((viewerNode = this.getViewerNode()) != null) {
            this._dbObject = viewerNode.getDBObject();
        }
        if (bl || this._dbObject != null && (this._lastdbObject == null || this._lastdbObject.getObjectName() != this._dbObject.getObjectName())) {
            final BasicEditorPane basicEditorPane = this.getCodeArea();
            ResultCallBack resultCallBack = new ResultCallBack(){

                @Override
                public void setResult(String string) {
                    basicEditorPane.setEditable(true);
                    basicEditorPane.setText(string);
                    basicEditorPane.setEditable(false);
                }
            };
            String string = this.getSchema1(resultCallBack, this._dbObject);
        }
    }

    protected String getSchema1(ResultCallBack resultCallBack, DBObject dBObject) {
        return TTSchemaSQLTab.getSchema(resultCallBack, this._dbObject);
    }

    public static String getDSN(DBObject dBObject) {
        try {
            String string = dBObject.getConnection().getMetaData().getURL().toString();
            String string2 = string.indexOf("TTC_SERVER_DSN") != -1 ? string.replaceAll("jdbc:timesten:direct:", "").replaceAll("jdbc:timesten:client:", "") : string.substring(string.indexOf("DSN=") + 4).replaceAll(";.*$", "");
            String string3 = Connections.getInstance().getConnectionInfo(dBObject.getConnectionName()).getProperty("user");
            if (string3 != null) {
                string2 = string2 + ";UID=" + string3;
            }
            return string2;
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return "";
        }
    }

    public static String getSchema(ResultCallBack resultCallBack, DBObject dBObject) {
        try {
            String string;
            boolean bl;
            String string2 = dBObject.getConnection().getMetaData().getURL().toString();
            String string3 = TTSchemaSQLTab.getDSN(dBObject);
            TTInstanceInformation tTInstanceInformation = TTInstanceInformation.getInstance();
            String string4 = dBObject.getConnectionName();
            Connections connections = Connections.getInstance();
            Properties properties = connections.getConnectionInfo(string4);
            String string5 = properties.getProperty("password");
            if (string5 == null) {
                string5 = X10ConnectionProperties.getTheInstance().getProperty(Connections.getConnectionName((String)string4), "sys1");
            }
            StringBuffer stringBuffer = new StringBuffer(string3);
            boolean bl2 = true;
            boolean bl3 = bl = string2.indexOf(":client:") != -1;
            if (!bl && tTInstanceInformation.accessControlEnabled() && (string = properties.getProperty("user")) != null && TTSchemaSQLTab.getCurrentUserName().equals(string)) {
                string5 = null;
                bl2 = false;
            }
            return TTSchema.getDDL(resultCallBack, string3, dBObject.getSchemaName(), dBObject.getObjectName(), bl, bl2, string5);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return "";
        }
    }

    private static String getCurrentUserName() {
        String string = "";
        try {
            string = System.getProperty("user.name");
            theLogger.info("Current user name" + string);
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, "Cannot get login name", exception);
        }
        return string;
    }

    public static interface ResultCallBack {
        public void setResult(String var1);
    }
}

