/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.DBObject;

public class MVLogDetails
extends TTTableViewer {
    private static final Logger _logger = Logger.getLogger(MVLogDetails.class.getPackage().getName());
    private MyTableModel _model;

    @Override
    protected final String GetPurposeTxt() {
        return "mvlog columns";
    }

    @Override
    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel(this._dbObject);
            this._table.setModel(this._model);
        } else {
            this._model.init(this._dbObject);
        }
        this._model.fireTableDataChanged();
    }

    public static class MyTableModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theViewInfoColumnNames = new String[]{Messages.getString("TimesTen.mvlog.detail.created"), Messages.getString("TimesTen.mvlog.detail.lastddltime"), Messages.getString("TimesTen.mvlog.detail.logowner"), Messages.getString("TimesTen.mvlog.detail.master"), Messages.getString("TimesTen.mvlog.detail.logtable")};
        private int theNoColumnsInViewInfo = this.theViewInfoColumnNames.length;

        private MyTableModel(DBObject dBObject) throws Exception {
            try {
                this.init(dBObject);
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process view information " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init(Connection connection, String string, String string2, String string3) throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                this.theRows.clear();
                String string4 = "select created , nvl(last_ddl_time,created) from sys.all_objects  where object_name = ?";
                statement = TimesTenUtil.prepareStatement(connection, string4);
                statement.setString(1, string2);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    Object[] objectArray = new Object[this.theNoColumnsInViewInfo];
                    objectArray[0] = resultSet.getString(1);
                    objectArray[1] = resultSet.getString(2);
                    objectArray[2] = string;
                    objectArray[3] = string3;
                    objectArray[4] = string2;
                    this.theRows.add(objectArray);
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process information " + sQLException.toString());
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        private String getMVLogName(Connection connection, String string) throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                this.theRows.clear();
                String string2 = "SELECT CONCAT('MVLOG$_',to_char(TBLID)) FROM SYS.TABLES WHERE TBLNAME=?";
                statement = TimesTenUtil.prepareStatement(connection, string2);
                statement.setString(1, string);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    return string3;
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process information " + sQLException.toString());
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            return "";
        }

        private void init(DBObject dBObject) throws SQLException {
            String string = dBObject.getSchemaName();
            String string2 = dBObject.getObjectName();
            Connection connection = dBObject.getConnection();
            String string3 = this.getMVLogName(connection, string2);
            this.init(connection, string, string3, string2);
        }

        @Override
        public final int getColumnCount() {
            return this.theViewInfoColumnNames.length;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theNoColumnsInViewInfo) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public final String getColumnName(int n) {
            return this.theViewInfoColumnNames[n];
        }
    }
}

