/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.CacheInfo;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.editors.AgingAttributes;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;

public final class CacheDetails
extends TTTableViewer {
    private MyTableModel _model;
    private static final Logger _logger = Logger.getLogger(AgingAttributes.class.getPackage().getName());

    @Override
    protected final String GetPurposeTxt() {
        return "cache details";
    }

    @Override
    protected void postCreateHook() {
        this._table.setAutoResizeMode(0);
    }

    @Override
    protected void createTableModel() throws Exception {
        _logger.log(Level.INFO, "CacheDetails createTableModel");
        if (this._model == null) {
            this._model = new MyTableModel();
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        this._model.fireTableDataChanged();
    }

    private class MyTableModel
    extends AbstractTableModel {
        static final int numCols = 2;
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        Hashtable<String, String> hash;

        private MyTableModel() throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process " + CacheDetails.this.GetPurposeTxt() + " " + sQLException.toString());
                throw sQLException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() throws Exception {
            try {
                this.hash = CacheInfo.getCacheInfo(CacheDetails.this._dbObject);
                this.theRows.clear();
                this.handleNameType();
                this.handleAutoRefresh();
                this.handleRootTable();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Generating " + CacheDetails.this.GetPurposeTxt() + " failed");
                _logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        }

        private final void addRow(String string, String string2) {
            this.theRows.add(new Object[]{string, this.hash.get(string2)});
        }

        private void handleNameType() {
            this.addRow(Messages.getString("CacheDetails.cacheGroupName"), "CACHE GROUP NAME");
            this.addRow(Messages.getString("CacheDetails.cacheGroupType"), "CACHE GROUP TYPE");
        }

        private void handleAutoRefresh() {
            this.addRow(Messages.getString("CacheDetails.autoRefreshEnabled"), "AUTOREFRESH ENABLED");
            if (this.hash.containsKey("AUTOREFRESH MODE")) {
                this.addRow(Messages.getString("CacheDetails.autoRefreshMode"), "AUTOREFRESH MODE");
                this.addRow(Messages.getString("CacheDetails.autoRefreshState"), "AUTOREFRESH STATE");
                this.addRow(Messages.getString("CacheDetails.autoRefreshIntreval"), "AUTOREFRESH INTERVAL+UNIT");
            }
        }

        private void handleRootTable() {
            this.addRow(Messages.getString("CacheDetails.rootTableName"), "ROOT TABLE FULLNAME");
            this.addRow(Messages.getString("CacheDetails.numberOfTableInCacheGroup"), "NUM TABLES");
        }

        @Override
        public final int getColumnCount() {
            return 2;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > 2) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TimesTen.common.attribute");
            }
            if (n == 1) {
                return Messages.getString("TimesTen.common.value");
            }
            return null;
        }
    }
}

