/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.util.LiveValidationController;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ValidationException;

public class SchemaEditor
extends DefaultTraversablePanel
implements ActionListener {
    private List<PanelLibrary.HeaderPanelListener> m_list = new ArrayList<PanelLibrary.HeaderPanelListener>();
    private final SchemaPicker _cmbOwner = new SchemaPicker();
    private final JTextField _fldName = new JTextField();
    private LiveValidationController _vController;
    private JLabel _lblPlsqlLowerCase = new JLabel();
    private JCheckBox _chkPlsqlLowerCase = new JCheckBox();
    protected boolean _listening;
    private SchemaObject _originalObject;
    private Schema[] _schemas;
    private SchemaObject _schemaObject;
    private DBObjectProvider _pro;
    private SchemaObjectInfoVerifier _verifier;

    public SchemaEditor() {
        this.buildPanel((JPanel)((Object)this));
    }

    private void buildPanel(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this._cmbOwner.addActionListener((ActionListener)this);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._cmbOwner, (String)UIArb.getString((int)108));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        jPanel.add((Component)this._cmbOwner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._fldName, (String)UIArb.getString((int)109));
        this._fldName.setColumns(15);
        this._vController = new LiveValidationController((JComponent)this._fldName);
        this._fldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            private void validate() {
                SchemaEditor.this._vController.showError(SchemaEditor.this.commitIdentifier());
            }
        });
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        jPanel.add((Component)this._fldName, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this._chkPlsqlLowerCase, (String)UIArb.getString((int)962));
        jPanel.add((Component)this._chkPlsqlLowerCase, new GridBagConstraints(0, 100, 0, 0, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void commitSchema() throws TraversalException {
        Schema schema = this._schemaObject.getSchema();
        Schema schema2 = this._cmbOwner.getSchema();
        this._schemaObject.setSchema(schema2);
        DBObjectChange.firePropertyChanged((SystemObject)this._schemaObject, (PropertyChangeEvent[])new PropertyChangeEvent[]{new PropertyChangeEvent(this._schemaObject, "schema", schema, schema2)});
    }

    private Schema[] validateSchemaPermissions(Schema[] schemaArray) {
        if (this._pro instanceof Database) {
            ArrayList<Schema> arrayList = new ArrayList<Schema>();
            String string = this._schemaObject.getType();
            for (int i = 0; i < schemaArray.length; ++i) {
                if (!this._pro.hasPriviledge(string, schemaArray[i], this.isEditing() ? "MODIFY" : "CREATE")) continue;
                arrayList.add(schemaArray[i]);
            }
            return arrayList.toArray(new Schema[arrayList.size()]);
        }
        return schemaArray;
    }

    protected SchemaObjectInfoVerifier getVerifier() {
        return this._verifier;
    }

    protected SchemaPicker getSchemaPicker() {
        return this._cmbOwner;
    }

    protected DBObjectProvider getProvider() {
        return this._pro;
    }

    protected SchemaObject getSchemaObject() {
        return this._schemaObject;
    }

    protected boolean isEditing() {
        return this._originalObject != null;
    }

    protected void init(SchemaObject schemaObject, SchemaObject schemaObject2, SchemaObjectInfoVerifier schemaObjectInfoVerifier, DBObjectProvider dBObjectProvider, Schema[] schemaArray) {
        this._originalObject = schemaObject2;
        this._pro = dBObjectProvider;
        this._schemaObject = schemaObject;
        this._schemas = schemaArray;
        this._verifier = schemaObjectInfoVerifier;
        this._cmbOwner.init(this._pro, schemaObject.getSchema(), this.validateSchemaPermissions(this._schemas));
        this._fldName.setText(schemaObject.getName());
        this._cmbOwner.setEnabled(this._verifier == null || this._verifier.canChangeSchema());
        this._cmbOwner.setEditable(this._verifier == null && !(dBObjectProvider instanceof Database) || this._verifier != null && this._verifier.canCreateSchema());
        this._fldName.setEnabled(this._verifier == null || this._verifier.canChangeName());
        this._listening = true;
        if (this._schemaObject instanceof SourceObject) {
            this._lblPlsqlLowerCase.setVisible(true);
            this._chkPlsqlLowerCase.setVisible(true);
            this._chkPlsqlLowerCase.setSelected(GlobalSettings.getInstance().isNewPlSqlLowerCase());
        } else {
            this._lblPlsqlLowerCase.setVisible(false);
            this._chkPlsqlLowerCase.setVisible(false);
        }
    }

    public void commit() throws TraversalException {
        this._listening = false;
        this.commitSchema();
        String string = this.commitIdentifier();
        if (string != null) {
            throw new TraversalException(string);
        }
        if (this._schemaObject instanceof SourceObject) {
            GlobalSettings.getInstance().setNewPlSqlLowerCase(this._chkPlsqlLowerCase.isSelected());
        }
    }

    private String commitIdentifier() {
        String string = this._schemaObject.getType();
        String string2 = this._schemaObject.getName();
        String string3 = this._fldName.getText();
        try {
            this._pro.validateName(string, string3);
        }
        catch (ValidationException validationException) {
            return validationException.getLocalizedMessage();
        }
        string3 = this._pro.getInternalName(string3, string);
        this._schemaObject.setName(string3);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this._schemaObject, "name", string2, string3);
        DBObjectChange.firePropertyChanged((SystemObject)this._schemaObject, (PropertyChangeEvent[])new PropertyChangeEvent[]{propertyChangeEvent});
        return null;
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Schema[] schemaArray = (Schema[])traversableContext.get("SchemaList");
        SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
        SchemaObject schemaObject2 = (SchemaObject)traversableContext.get("OriginalObject");
        SchemaObjectInfoVerifier schemaObjectInfoVerifier = (SchemaObjectInfoVerifier)traversableContext.get("SchemaObjectInfoVerifier");
        this.init(schemaObject, schemaObject2, schemaObjectInfoVerifier, dBObjectProvider, schemaArray);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        try {
            DBUtil.getProviderDefinition((DBObject)this._schemaObject, (DBObjectProvider)this._pro);
        }
        catch (DBException dBException) {
            throw new TraversalException(dBException.getLocalizedMessage());
        }
        this.commit();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._listening) {
            try {
                this.commitSchema();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
        }
    }

    public final void addHeaderPanelListener(PanelLibrary.HeaderPanelListener headerPanelListener) {
        this.m_list.add(headerPanelListener);
    }

    public final boolean removeHeaderPanelListener(PanelLibrary.HeaderPanelListener headerPanelListener) {
        return this.m_list.remove(headerPanelListener);
    }

    protected final void changePanels(String string, Navigable[] navigableArray) throws TraversalException {
        for (PanelLibrary.HeaderPanelListener headerPanelListener : this.m_list) {
            headerPanelListener.panelSetChange(string, navigableArray);
        }
    }
}

