/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.commands.TTSchema;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.dbtools.raptor.timesten.editors.TTSchemaSQLTab;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public final class ImportData
extends AbstractMenuAction {
    public final void setArgs(String string) {
    }

    public void launch() {
        try {
            DBObject dBObject = this.getDBObject();
            String string = dBObject.getConnection().getMetaData().getURL().toString();
            boolean bl = string.indexOf(":client:") != -1;
            ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)this.getObjectAction(), (DBObject)dBObject);
            this.setBlockOACRefresh(true);
            JFileChooser jFileChooser = new JFileChooser(){

                @Override
                public void approveSelection() {
                    File file = this.getSelectedFile();
                    if (!file.exists() || file.isDirectory()) {
                        return;
                    }
                    super.approveSelection();
                }
            };
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showOpenDialog((Component)Ide.getMainWindow());
            if (n == 0) {
                String[] stringArray;
                File file = jFileChooser.getSelectedFile();
                String string2 = dBObject.getSchemaName() + "." + dBObject.getObjectName();
                String string3 = TTSchemaSQLTab.getDSN(dBObject);
                String string4 = (string3.indexOf("TTC_SERVER_DSN") == -1 ? "dsn=" : "") + string3;
                String[] stringArray2 = new String[6];
                boolean bl2 = System.getProperty("os.name").toLowerCase().startsWith("windows");
                stringArray2[0] = bl && !bl2 ? "ttbulkcpcs" : "ttbulkcp";
                stringArray2[1] = "-i";
                stringArray2[2] = "-connStr";
                stringArray2[3] = "\"" + string4 + "\"";
                stringArray2[4] = "\"" + string2 + "\"";
                stringArray2[5] = "\"" + file.getPath() + "\"";
                String string5 = dBObject.getConnectionName();
                Connections connections = Connections.getInstance();
                Properties properties = connections.getConnectionInfo(string5);
                String string6 = properties.getProperty("password");
                if (string6 == null) {
                    string6 = X10ConnectionProperties.getTheInstance().getProperty(Connections.getConnectionName((String)string5), "sys1");
                }
                if ((stringArray = TTSchema.run(stringArray2, true, string6))[1] != null) {
                    objectActionPostProcess = null;
                    String string7 = stringArray[1];
                    string7 = TTSQLExceptionScrubber.getMessage(string7, null, Logger.getLogger(ImportData.class.getPackage().getName()));
                    string7 = string7.replaceAll("Run 'ttBulkCp -help' for usage information.", "");
                    string7 = string7.replaceAll("\n", " ");
                    MessageDialog.error(null, (Object)string7, (String)Messages.getString("TimesTen.common.error"), null);
                }
            } else {
                objectActionPostProcess = null;
            }
            if (objectActionPostProcess != null) {
                objectActionPostProcess.run();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(ImportData.class.getPackage().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execCmd(String string) {
        BufferedReader bufferedReader = null;
        boolean bl = true;
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuffer stringBuffer = new StringBuffer(256);
            while ((string2 = bufferedReader2.readLine()) != null) {
                stringBuffer.append(string2);
            }
            bufferedReader2.close();
            if (stringBuffer.length() > 0) {
                bl = false;
                String string3 = stringBuffer.toString();
                string3 = TTSQLExceptionScrubber.getMessage(string3, null, Logger.getLogger(ImportData.class.getPackage().getName()));
                string3 = string3.replaceAll("Run 'ttBulkCp -help' for usage information.", "");
                string3 = string3.replaceAll("\n", " ");
                MessageDialog.error(null, (Object)string3, (String)Messages.getString("TimesTen.common.error"), null);
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }
}

