/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.UIArb;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.dialogs.ExceptionDialog;

public class DDLPanel
extends DefaultTraversablePanel
implements ActionListener,
SchemaObjectListener {
    public static final String DDL_GENERATOR = "DDlGenerator";
    private static final String EXT = ".sql";
    private static URLFilter SQL_FILTER = new DefaultURLFilter(UIArb.getString((int)142), ".sql");
    private JButton m_btnSave;
    private final JTextArea m_txtSQL = new JTextArea();
    private boolean m_showRadio;
    private ButtonGroup m_btnGrp;
    private JRadioButton m_rdbCreate;
    private JRadioButton m_rdbUpdate;
    private TraversableContext m_data;

    public DDLPanel() {
        this(false);
    }

    public DDLPanel(boolean bl) {
        this.m_showRadio = bl;
        this.setHelpID("f1_odbviddl_html");
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this.m_data == null) {
            this.m_data = traversableContext;
            this.getComponent();
        }
        SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
        schemaObject.addObjectListener((SchemaObjectListener)this);
        this.updateSQL();
    }

    private void updateSQL() {
        String string = this.getSQL(this.m_data);
        this.m_txtSQL.setText(string);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
        schemaObject.removeObjectListener((SchemaObjectListener)this);
    }

    public static DDLGenerator getDDLGenerator(TraversableContext traversableContext) {
        DDLGenerator dDLGenerator = (DDLGenerator)traversableContext.get(DDL_GENERATOR);
        if (dDLGenerator == null) {
            DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
            dDLGenerator = dBObjectProvider.getDescriptor().getDDLGenerator(dBObjectProvider);
        }
        return dDLGenerator;
    }

    protected String getSQL(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
        SchemaObject schemaObject2 = (SchemaObject)traversableContext.get("OriginalObject");
        SchemaObject[] schemaObjectArray = (SchemaObject[])traversableContext.get("NewSecondaryDBObjects");
        DDLGenerator dDLGenerator = DDLPanel.getDDLGenerator(traversableContext);
        DDL[] dDLArray = null;
        dDLArray = new DDL[]{dDLGenerator.getCreateDDL(new DDLOptions(false, false), new DBObject[]{schemaObject})};
        StringBuffer stringBuffer = new StringBuffer();
        if (dDLArray != null) {
            for (int i = 0; i < dDLArray.length; ++i) {
                stringBuffer.append(dDLArray[i].toString());
            }
        }
        return stringBuffer.toString();
    }

    public Component getComponent() {
        if (this.getComponentCount() == 0) {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_txtSQL, (String)UIArb.getString((int)131));
            this.m_btnSave = new JButton();
            this.m_btnSave.addActionListener(this);
            ResourceUtils.resButton((AbstractButton)this.m_btnSave, (String)UIArb.getString((int)132));
            this.m_txtSQL.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(this.m_txtSQL);
            int n = 0;
            this.add(jLabel, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(jScrollPane, new GridBagConstraints(0, n++, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add(this.m_btnSave, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnSave) {
            Object object2;
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.clearChooseableURLFilters();
            uRLFileChooser.setURLFilter(SQL_FILTER);
            URL uRL = null;
            while (uRLFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
                uRL = uRLFileChooser.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)uRL))) {
                    object2 = URLFileSystem.getPath((URL)uRL);
                    uRL = URLFactory.replacePathPart((URL)uRL, (String)((String)object2 + EXT));
                }
                try {
                    uRL = NewFilePanel.validateURL((Component)((Object)this), (URL)uRL, (String)UIArb.getString((int)141), (boolean)true);
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this));
                    break;
                }
                if (uRL == null) continue;
            }
            if (uRL != null) {
                try {
                    object2 = URLFileSystem.openOutputStream((URL)uRL);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object2, IdeUtil.getIdeEncoding()));
                    bufferedWriter.write(this.m_txtSQL.getText());
                    ((Writer)bufferedWriter).flush();
                    ((Writer)bufferedWriter).close();
                }
                catch (IOException iOException) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)iOException, (String)UIArb.getString((int)133), (String)UIArb.getString((int)134), null);
                }
            }
        } else {
            this.updateSQL();
        }
    }

    public void schemaObjectUpdated(DBObjectChange dBObjectChange) {
        this.updateSQL();
    }
}

