/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

class CheckboxTitledBorder
implements Border {
    static final Color CHECKBOX_FOCUS_COLOR = UIManager.getColor("CheckBox.focus");
    static final Insets CHECKBOX_INSETS = UIManager.getInsets("CheckBox.totalInsets");
    static final int OFFSET = CheckboxTitledBorder.CHECKBOX_INSETS.right + 2;
    JCheckBox _checkbox;
    JComponent _container;
    Rectangle _rect;
    Border _border;
    boolean _hasFocus = false;

    public CheckboxTitledBorder(JCheckBox jCheckBox, JComponent jComponent, Border border) {
        this._checkbox = jCheckBox;
        this._container = jComponent;
        this._border = border;
        this._container.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                CheckboxTitledBorder.this.dispatchEvent(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                CheckboxTitledBorder.this.dispatchEvent(mouseEvent);
            }
        });
        this._container.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CheckboxTitledBorder.this._hasFocus = false;
                CheckboxTitledBorder.this._container.repaint();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CheckboxTitledBorder.this._hasFocus = true;
                CheckboxTitledBorder.this._container.repaint();
            }
        });
    }

    @Override
    public Insets getBorderInsets(Component component) {
        Dimension dimension = this._checkbox.getPreferredSize();
        Insets insets = this._border.getBorderInsets(component);
        insets.top = Math.max(insets.top, dimension.height);
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets = this._border.getBorderInsets(component);
        Insets insets2 = this.getBorderInsets(component);
        int n5 = (insets2.top - insets.top) / 2;
        this._border.paintBorder(component, graphics, n, n2 + n5, n3, n4 - n5);
        Dimension dimension = this._checkbox.getPreferredSize();
        this._rect = new Rectangle(OFFSET, 0, dimension.width, dimension.height);
        SwingUtilities.paintComponent(graphics, this._checkbox, (Container)component, this._rect);
        if (this._hasFocus) {
            insets2 = CHECKBOX_INSETS;
            n3 = (insets2.left + insets2.right) * 2;
            n4 = (insets2.top + insets2.bottom) / 2;
            graphics.setColor(CHECKBOX_FOCUS_COLOR);
            graphics.drawRect(this._rect.x + n3, this._rect.y + n4 / 2, this._rect.width - n3, this._rect.height - n4);
        }
    }

    private void dispatchEvent(MouseEvent mouseEvent) {
        if (this._rect != null && this._rect.contains(mouseEvent.getX(), mouseEvent.getY())) {
            Point point = mouseEvent.getPoint();
            point.translate(-OFFSET, 0);
            this._checkbox.setBounds(this._rect);
            this._checkbox.dispatchEvent(new MouseEvent(this._checkbox, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            this._container.requestFocus();
            if (!this._checkbox.isValid()) {
                this._container.repaint();
            }
        }
    }
}

