/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.controls.celleditor.popups;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.celleditor.popups.ExtendedTypeEditPanel;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.mimeeditor.ExternalBlobEditor;
import oracle.dbtools.raptor.timesten.extendedtype.BasicBinaryType;
import oracle.dbtools.raptor.timesten.extendedtype.VarBinaryType;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;

public class TTVarBinaryEditPanel<T extends BasicBinaryType<?>>
extends ExtendedTypeEditPanel {
    protected URL loadFromURL = null;
    protected static URL _lastLoadUrl;
    protected T newValue;
    private static final Logger theLogger;
    protected static boolean showImage;

    public TTVarBinaryEditPanel(T t) {
        super(t);
        this.loadFromURL = null;
        try {
            this.newValue = (BasicBinaryType)((BasicBinaryType)t).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            theLogger.log(Level.SEVERE, "Unexpected internal error: " + cloneNotSupportedException.getLocalizedMessage(), cloneNotSupportedException);
        }
    }

    public TTVarBinaryEditPanel() {
        super((ExtendedType)new VarBinaryType(null));
    }

    protected void createGUI() {
        this.createDefaultGUI();
    }

    protected void addSavedInfoHeaderComps() {
        this.savedInfoHeaderPanel.getHeader().addActionControl((Component)this.getExtEditorButton());
        super.addSavedInfoHeaderComps();
    }

    protected String[][] getTableData() {
        String string = "";
        try {
            string = Long.toString(((BasicBinaryType)this.extendedType).length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[][]{{Messages.getString((String)"BLOBEditPanel.8"), string}};
    }

    protected void load() {
        Object object;
        this.loadFromURL = null;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setDefaultTitle(Messages.getString((String)"BLOBEditPanel.9"));
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.clearChooseableURLFilters();
        if (_lastLoadUrl == null) {
            object = System.getProperty("user.home");
            File file = new File((String)object);
            uRLFileChooser.setSelectedURL(URLFactory.newFileURL((File)file));
        } else {
            uRLFileChooser.setSelectedURL(_lastLoadUrl);
        }
        object = new File(uRLFileChooser.getSelectedURL().getFile());
        if (((File)object).isDirectory()) {
            try {
                uRLFileChooser.setSelectedURL(new URL(uRLFileChooser.getSelectedURL() + File.separator + this.getFileName()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRLFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            if (this.extendedType != null) {
                this.extendedType.setNULL(false);
            }
            this.loadFromURL = uRLFileChooser.getSelectedURL();
            if (this.newValue != null) {
                theLogger.log(Level.FINEST, "Resetting URL to: " + this.loadFromURL);
                this.newValue.setLoadFromURL(this.loadFromURL);
            }
            _lastLoadUrl = this.loadFromURL;
            if (this._dialog != null) {
                this._dialog.closeDialog(false);
            }
        }
    }

    public URL getLoadFromURL() {
        return this.loadFromURL;
    }

    public boolean processExtendedType() {
        this.saveToDisk();
        URL uRL = this.getLoadFromURL();
        if (uRL != null) {
            if (this.newValue == null) {
                this.newValue = new VarBinaryType();
            }
            if (this.newValue != null) {
                this.newValue.setLoadFromURL(uRL);
                return true;
            }
        } else if (this.extendedType != null && (this.extendedType.isSetNULL() || this.extendedType.getLoadFromURL() != null)) {
            return true;
        }
        return false;
    }

    public JComponent getDefaultComponent() {
        return this;
    }

    public String getHelpTopicId() {
        return "f1_BLOBpopupeditor_html";
    }

    public Object getValue() {
        if (this.extendedType != null && this.extendedType.isSetNULL()) {
            return null;
        }
        if (this.processExtendedType()) {
            if (this.newValue == this.extendedType) {
                theLogger.log(Level.SEVERE, "blob " + this.newValue.hashCode() + " extendedType " + this.extendedType.hashCode());
            }
            return this.newValue;
        }
        if (this.isFileEdited()) {
            return this.newValue;
        }
        return this.extendedType;
    }

    public void setValue(Object object) {
        this.loadFromURL = null;
        this.newValue = null;
        if (object instanceof String) {
            if (((String)object).length() == 0) {
                this.extendedType = new VarBinaryType(null);
            } else {
                theLogger.log(Level.SEVERE, "Unexpected internal error: value " + object);
            }
        } else {
            this.extendedType = (BasicBinaryType)object;
        }
        try {
            this.newValue = this.extendedType != null ? (BasicBinaryType)((BasicBinaryType)this.extendedType).clone() : new VarBinaryType(null);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            theLogger.log(Level.SEVERE, "Unexpected internal error: " + cloneNotSupportedException.getLocalizedMessage(), cloneNotSupportedException);
        }
        this.reload();
    }

    protected void reload() {
        this.loadFromURL = null;
        boolean bl = false;
        if (this.extendedType == null) {
            bl = true;
        }
        if (bl) {
            this.saveButton.setEnabled(false);
            this.savedViewAsImageBtn.setEnabled(false);
            this.savedViewAsTextBtn.setEnabled(false);
            this.extEditorButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(true);
            this.savedViewAsImageBtn.setEnabled(true);
            this.savedViewAsTextBtn.setEnabled(true);
            this.extEditorButton.setEnabled(true);
        }
        if (this.extendedType != null && this.extendedType.getLoadFromURL() == null) {
            this.localViewAsImageBtn.setEnabled(false);
            this.localViewAsTextBtn.setEnabled(false);
        } else {
            this.localViewAsImageBtn.setEnabled(true);
            this.localViewAsTextBtn.setEnabled(true);
        }
        super.reload();
    }

    protected HyperlinkButton getExtEditorButton() {
        ResourceUtils.resButton((AbstractButton)this.extEditorButton, (String)Messages.getString((String)"ExtendedTypeEditPanel.19"));
        this.extEditorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTVarBinaryEditPanel.this.externalEditor();
            }
        });
        return this.extEditorButton;
    }

    protected JPanel getButtonPanel() {
        return null;
    }

    protected void externalEditor() {
        if (this.extendedType != null) {
            final ExternalBlobEditor externalBlobEditor = new ExternalBlobEditor();
            RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    if (externalBlobEditor.isFileModified()) {
                        TTVarBinaryEditPanel.this.setFileEdited(true);
                    } else {
                        TTVarBinaryEditPanel.this.setFileEdited(false);
                    }
                }
            };
            externalBlobEditor.startExternalBlobEditor(this.newValue, raptorTaskAdapter);
        }
    }

    static {
        theLogger = Logger.getLogger(TTVarBinaryEditPanel.class.getPackage().getName());
        showImage = false;
    }
}

