/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.net.URL;
import java.sql.Connection;
import javax.swing.Icon;
import oracle.dbtools.raptor.LazyIcon;
import oracle.dbtools.raptor.navigator.filter.FilterDetails;
import oracle.dbtools.raptor.navigator.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.timesten.TimesTenNLSProvider;
import oracle.dbtools.raptor.utils.Connections;

public class TimesTenConnectionTypeDetails
extends ConnectionTypeDetails {
    public FilterDetails getFilterDetails() {
        return MyFilterDetails.getInstance();
    }

    public boolean isOracle() {
        return true;
    }

    public Integer getPreferredFetchSize() {
        return 0;
    }

    public DefaultNLSProvider getNLSProvider(Connection connection) {
        if (Connections.getInstance().isTimesTen(connection)) {
            return new TimesTenNLSProvider(connection);
        }
        return null;
    }

    public boolean isSupportsAutocommit() {
        return true;
    }

    public boolean isColumnTypeSortable(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case -3: 
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public Icon getIcon(DBItemInstance dBItemInstance) {
        String string = (String)dBItemInstance.getProperty("ConnectionType");
        if (string == null) {
            return super.getIcon(dBItemInstance);
        }
        if (!string.equalsIgnoreCase("TimesTen")) {
            return super.getIcon(dBItemInstance);
        }
        if (!dBItemInstance.getDescriptor().getType().equalsIgnoreCase("TABLE")) {
            return super.getIcon(dBItemInstance);
        }
        Object object = dBItemInstance.getProperty("CACHEGROUP");
        if (object == null) {
            return super.getIcon(dBItemInstance);
        }
        if (!object.toString().equals("0")) {
            try {
                URL uRL = ((Object)((Object)this)).getClass().getResource("/oracle/dbtools/raptor/timesten/images/cached_table.png");
                LazyIcon lazyIcon = new LazyIcon(uRL);
                return lazyIcon;
            }
            catch (Exception exception) {
                return super.getIcon(dBItemInstance);
            }
        }
        return super.getIcon(dBItemInstance);
    }

    private static class MyFilterDetails
    extends FilterDetails {
        private MyFilterDetails() {
        }

        private static MyFilterDetails getInstance() {
            return new MyFilterDetails();
        }

        public boolean isSupportsCaseInsensitiveFilters() {
            return false;
        }
    }
}

