/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.editors.ViewMetaDataViewer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.util.IdeUtil;

public class Describe
extends CommandListener {
    private static final String THE_EMPTY_STRING;
    private static final String DESCRIBE_TITLE = "Name                           Null     Type \n";
    private static final String DESCRIBE_UNDERLINE = "------------------------------ -------- -----------------------------------------------------------------------------------------------------------\n";

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            String[] stringArray;
            String string = connection.getMetaData().getDatabaseProductName();
            String string2 = connection.getMetaData().getUserName();
            String string3 = iSQLCommand.getSql();
            if (string3 != null && string.equalsIgnoreCase("timesten") && string3.toUpperCase().indexOf("DESC") == 0 && (stringArray = string3.split("\\s+")).length >= 2) {
                String string4 = connection.getMetaData().getURL().toString();
                String string5 = string4.substring(string4.indexOf("DSN=") + 4);
                if (string5.indexOf(";") > 0) {
                    string5 = string5.substring(0, string5.indexOf(";"));
                }
                int n = stringArray[1].indexOf(";");
                String string6 = null;
                string6 = n != -1 ? stringArray[1].substring(0, n) : stringArray[1];
                string6 = string6.toUpperCase();
                List<String> list = this.executeDescribeSql(connection, string6, string2);
                scriptRunnerContext.getOutputStream().write(("\n" + iSQLCommand.getSql() + "\n").getBytes(IdeUtil.getIdeEncoding()));
                for (String string7 : list) {
                    scriptRunnerContext.getOutputStream().write(string7.getBytes(IdeUtil.getIdeEncoding()));
                }
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }

    private List<String> executeDescribeSql(Connection connection, String string, String string2) throws Exception {
        ArrayList<String> arrayList;
        Statement statement = null;
        Object var5_5 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(32);
        try {
            int n;
            int n2;
            Object object;
            Object object2;
            Object object3;
            ResultSet resultSet;
            Object object4;
            String string3;
            String[] stringArray = string.split("\\.", 2);
            if (stringArray.length > 1) {
                string3 = stringArray[0];
                string = stringArray[1];
            } else {
                string3 = string2;
            }
            Object object5 = Describe.getObjectType(connection, string3, string);
            arrayList2.add((String)object5 + " " + string3 + "." + string + ":\n");
            boolean bl = false;
            if (((String)object5).equalsIgnoreCase("SYNONYM")) {
                while (((String)object5).equalsIgnoreCase("SYNONYM")) {
                    object4 = "select rtrim(table_owner), rtrim(table_name) from sys.all_synonyms where (rtrim(owner) = :OBJECT_OWNER) and (rtrim(synonym_name) = :OBJECT_NAME)";
                    statement = Describe.getPreparedStatement((String)object4, string3, string, connection);
                    resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        object2 = Describe.getObjectType(connection, string4, (String)(object3 = resultSet.getString(2)));
                        if (!object2.equalsIgnoreCase("SYNONYM")) {
                            arrayList2.add("For " + (String)object2 + " " + string4 + "." + (String)object3 + "\n");
                        }
                        object5 = object2;
                        string = object3;
                        string3 = string4;
                    }
                    statement.close();
                }
                bl = true;
            }
            if (((String)object5).equalsIgnoreCase("TABLE") || ((String)object5).equalsIgnoreCase("MATERIALIZED VIEW")) {
                object4 = "select tblname from sys.tables t where ((tblowner = :OBJECT_OWNER) and (tblname =  :OBJECT_NAME) and (SYS25 & 2097152 = 2097152))";
                statement = Describe.getPreparedStatement((String)object4, string3, string, connection);
                resultSet = statement.executeQuery();
                boolean bl2 = resultSet.next();
                object3 = QueryCache.getQuery((String)"timesten.table.metadata").getSql();
                statement = Describe.getPreparedStatement((String)object3, string3, string, connection);
                resultSet = statement.executeQuery();
                object2 = new char[128];
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object2[i] = 32;
                }
                object = new String((char[])object2);
                n2 = resultSet.next();
                n = 0;
                if (n2 != 0) {
                    ++n;
                    arrayList2.add(DESCRIBE_TITLE);
                    arrayList2.add(DESCRIBE_UNDERLINE);
                    do {
                        Describe.formatData(arrayList2, resultSet.getString(1), resultSet.getString(2), resultSet.getString(3));
                    } while (resultSet.next());
                    if (bl2) {
                        arrayList2.add("  Has a materialized view log\n");
                    }
                    arrayList2.add("\n" + n + " rows selected\n");
                }
                bl = true;
            }
            if (((String)object5).equalsIgnoreCase("VIEW")) {
                object4 = ViewMetaDataViewer.getViewMetaData(connection, string3, string);
                int n3 = ((ViewMetaDataViewer.MyTableModel)object4).getNoColumns();
                for (int i = 0; i < n3; ++i) {
                    Describe.formatData(arrayList2, (String)((ViewMetaDataViewer.MyTableModel)object4).getValueAt(i, 0), (String)((ViewMetaDataViewer.MyTableModel)object4).getValueAt(i, 1), (String)((ViewMetaDataViewer.MyTableModel)object4).getValueAt(i, 2));
                }
                bl = true;
            }
            if (((String)object5).equalsIgnoreCase("PACKAGE")) {
                bl = true;
            }
            if (((String)object5).equalsIgnoreCase("FUNCTION") || ((String)object5).equalsIgnoreCase("PROCEDURE")) {
                object4 = "select position,argument_name,in_out,data_type from all_arguments where owner = :OBJECT_OWNER and object_name = :OBJECT_NAME";
                if (statement != null) {
                    statement.close();
                }
                statement = Describe.getPreparedStatement(object4, string3, string, connection);
                ResultSet resultSet2 = statement.executeQuery();
                int n4 = 0;
                object3 = new Hashtable();
                while (resultSet2.next()) {
                    object2 = resultSet2.getString(1).trim();
                    object = resultSet2.getString(2);
                    String string5 = resultSet2.getString(3);
                    String string6 = resultSet2.getString(4);
                    if (object == null) {
                        object = "<return value>";
                    }
                    ((Hashtable)object3).put(object2, new String[]{object, string6, string5});
                    ++n4;
                }
                if (n4 == 0) {
                    arrayList2.add("    (none)\n");
                } else {
                    int n5;
                    int n6;
                    int n7;
                    object2 = new String[]{"Argument Name", "Type", "In/Out"};
                    object = new int[]{0, 0, 0};
                    for (n2 = 0; n2 < 3; ++n2) {
                        object[n2] = object2[n2].length();
                    }
                    String string7 = "";
                    n = 1;
                    int n8 = n4;
                    if (((String)object5).equalsIgnoreCase("FUNCTION")) {
                        --n;
                        --n8;
                    }
                    for (n7 = n; n7 <= n8; ++n7) {
                        String[] stringArray2 = (String[])((Hashtable)object3).get(n7 + "");
                        if (stringArray2 == null) continue;
                        for (n6 = 0; n6 < 3; ++n6) {
                            object[n6] = Math.max((int)object[n6], stringArray2[n6].length());
                        }
                    }
                    for (n7 = 0; n7 < 3; ++n7) {
                        string7 = string7 + "%-" + (int)object[n7] + "s ";
                    }
                    string7 = "" + string7.trim() + "\n";
                    arrayList2.add(String.format(string7, object2[0], object2[1], object2[2]));
                    StringBuffer stringBuffer = new StringBuffer();
                    for (n5 = 0; n5 < 3; ++n5) {
                        for (n6 = 0; n6 < object[n5]; ++n6) {
                            stringBuffer.append("-");
                        }
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("\n");
                    arrayList2.add(stringBuffer.toString());
                    for (n5 = n; n5 <= n8; ++n5) {
                        String[] stringArray3 = (String[])((Hashtable)object3).get(n5 + "");
                        arrayList2.add(String.format(string7, stringArray3[0], stringArray3[1], stringArray3[2]));
                    }
                }
                bl = true;
            }
            if (bl) {
                object4 = arrayList2;
                return object4;
            }
            object4 = ((String)object5).equals("") ? String.format(Messages.getString("Describe.objNotFound"), string3 + "." + string) : String.format(Messages.getString("Describe.noInfo"), string3 + "." + string);
            arrayList2.clear();
            arrayList2.add((String)object4);
            arrayList = arrayList2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private static String fixupNameAndOwner(String string, String string2, String string3) {
        String string4 = string;
        string4 = string.replace(":OBJECT_OWNER", "'" + string2 + "'");
        string4 = string4.replace(":OBJECT_NAME", "'" + string3 + "'");
        return string4;
    }

    private static PreparedStatement getPreparedStatement(String string, String string2, String string3, Connection connection) throws SQLException {
        Connections connections = Connections.getInstance();
        PreparedStatement preparedStatement = null;
        try {
            connections = Connections.getInstance();
            connections.lock(connection);
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            PreparedStatement preparedStatement2 = preparedStatement;
            return preparedStatement2;
        }
        catch (SQLException sQLException) {
            throw TTSQLExceptionScrubber.cloneScrubbedSQLException(sQLException, string);
        }
        finally {
            connections.unlock(connection);
        }
    }

    private static void formatData(List<String> list, String string, String string2, String string3) {
        if (list.size() == 0) {
            list.add(DESCRIBE_TITLE);
            list.add(DESCRIBE_UNDERLINE);
        }
        StringBuffer stringBuffer = new StringBuffer(THE_EMPTY_STRING);
        stringBuffer.insert(0, string);
        stringBuffer.insert(31, string3.equalsIgnoreCase("Yes") ? "" : "NOT NULL");
        stringBuffer.insert(40, string2);
        stringBuffer.append("\n");
        list.add(stringBuffer.toString());
    }

    private static String getObjectType(Connection connection, String string, String string2) throws SQLException {
        ResultSet resultSet;
        String string3 = "select object_type from sys.all_objects where owner = ? and object_name = ?";
        String string4 = "";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = Describe.getPreparedStatement(string3, string, string2, connection);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string4 = resultSet.getString(1).trim();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        if (string4.equalsIgnoreCase("TABLE")) {
            string3 = "select name from sys.views where (owner = :OBJECT_OWNER and name = :OBJECT_NAME and sys4 & 1 = 1)";
            try {
                preparedStatement = Describe.getPreparedStatement(string3, string, string2, connection);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string4 = "MATERIALIZED VIEW";
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (string4.length() > 1) {
            string4 = string4.substring(0, 1).toUpperCase() + string4.substring(1).toLowerCase();
        }
        return string4;
    }

    static {
        char[] cArray = new char[128];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        THE_EMPTY_STRING = new String(cArray);
    }
}

