/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.SupportedObjectType;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class TimesTenUtil {
    private static final String[] SYSTEM_SCHEMA;
    private static List<String> _supportedObjects;
    private static Logger theLogger;
    private static final String[] SUPPORTED_VERSIONS;

    public static String getRegExForSupportedDrivers() {
        StringBuffer stringBuffer = new StringBuffer(256 * SUPPORTED_VERSIONS.length);
        for (int i = 0; i < SUPPORTED_VERSIONS.length; ++i) {
            String string = SUPPORTED_VERSIONS[i].replace(".", "\\.");
            stringBuffer.append("TimesTen\\s+Data\\s+Manager\\s+");
            stringBuffer.append(string);
            stringBuffer.append("|");
            stringBuffer.append("TimesTen\\s+Data\\s+Manager\\s+Debug\\s+");
            stringBuffer.append(string);
            stringBuffer.append("|");
            stringBuffer.append("TimesTen\\s+Client\\s+");
            stringBuffer.append(string);
            stringBuffer.append("|");
            stringBuffer.append("\\s*TimesTen\\s+" + string + "\\s+Driver\\s*");
            stringBuffer.append("|");
            stringBuffer.append("\\s*TimesTen\\s+" + string + "\\s+Client\\s+Driver\\s*");
            if (i == SUPPORTED_VERSIONS.length - 1) continue;
            stringBuffer.append("|");
        }
        return stringBuffer.toString();
    }

    public static boolean isSystemSchema(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : SYSTEM_SCHEMA) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSystemObject(DBObject dBObject) {
        String string = dBObject.getSchemaName();
        return TimesTenUtil.isSystemSchema(string);
    }

    public static List<String> getSupportedObjects() {
        return _supportedObjects;
    }

    public static String ttVersion(DBObject dBObject) {
        return TimesTenUtil.ttVersion(dBObject.getConnection());
    }

    public static String ttVersion(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData.getDatabaseProductVersion();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String ttFullDotVersion(Connection connection) {
        String string = null;
        try {
            String string2 = connection.getMetaData().getDatabaseProductVersion();
            String[] stringArray = string2.split("\\s+");
            if (stringArray.length > 0) {
                string = stringArray[0];
            } else {
                theLogger.log(Level.SEVERE, "Cannot get full dotted product version " + string2);
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Cannot assess database version", sQLException);
        }
        return string;
    }

    public static String getActiveStandbyOwner(Connection connection) {
        String string = "TTREP";
        try {
            int n = connection.getMetaData().getDatabaseMajorVersion();
            if (n >= 11) {
                return string;
            }
            return "TIMESTEN";
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "Cannot get database major version");
            return string;
        }
    }

    public static boolean isClientServer(Connection connection) {
        try {
            String string = connection.getMetaData().getURL().toString();
            if (string.indexOf(":client:") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        Connections connections = Connections.getInstance();
        PreparedStatement preparedStatement = null;
        try {
            connections = Connections.getInstance();
            connections.lock(connection);
            PreparedStatement preparedStatement2 = preparedStatement = connection.prepareStatement(string);
            return preparedStatement2;
        }
        catch (SQLException sQLException) {
            throw TTSQLExceptionScrubber.cloneScrubbedSQLException(sQLException, string);
        }
        finally {
            connections.unlock(connection);
        }
    }

    static {
        SupportedObjectType[] supportedObjectTypeArray;
        SYSTEM_SCHEMA = new String[]{"PUBLIC", "SYS", "TTREP", "GRID", "SYSTEM"};
        _supportedObjects = new ArrayList<String>(16);
        theLogger = Logger.getLogger(TimesTenUtil.class.getPackage().getName());
        for (SupportedObjectType supportedObjectType : supportedObjectTypeArray = SupportedObjectType.values()) {
            _supportedObjects.add(supportedObjectType.getTag());
        }
        SUPPORTED_VERSIONS = new String[]{"11.2.1", "11.2.2"};
    }
}

