/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.jdbc.DMDBuilder;

public class TTTableBuilder<T extends Table>
extends DMDBuilder<T> {
    private DatabaseMetaData theDbmd;

    public TTTableBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string, "TABLE");
    }

    public T createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Table table = new Table(string, schema);
        table.setID(dBObjectID);
        return (T)table;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
    public void fillInColumns(Table table) throws DBException {
        ResultSet resultSet = null;
        Column column = null;
        try {
            this.theDbmd = this.getConnection().getMetaData();
            resultSet = this.theDbmd.getColumns(null, table.getSchema().getName(), table.getName(), null);
            while (resultSet.next()) {
                column = new Column(resultSet.getString(4));
                table.addColumn(column);
                column.setID((DBObjectID)new NameBasedID((DBObject)column, table.getID()));
            }
        }
        catch (SQLException sQLException) {
            throw new DBException((Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

