/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.timesten.DataSheet;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.ddlgen.TimesTenBundleGenerator;
import oracle.dbtools.raptor.timesten.validators.TTIndexValidator;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.timesten.TimesTenDatabaseDescriptor;
import oracle.javatools.db.validators.PackageValidator;
import oracle.javatools.db.validators.PlSqlValidator;
import oracle.javatools.db.validators.SequenceValidator;

public class TTPlugInDatabaseDescriptor
extends TimesTenDatabaseDescriptor {
    private static final List<String> DEFAULT_PREFERRED_DATETYPES = new ArrayList<String>(32);
    private TimesTenPlugInDatabaseImpl theDbProvider;

    public TTPlugInDatabaseDescriptor(Class clazz) {
        super(clazz);
    }

    public TTPlugInDatabaseDescriptor(TimesTenPlugInDatabaseImpl timesTenPlugInDatabaseImpl) {
        super(((Object)((Object)timesTenPlugInDatabaseImpl)).getClass());
        this.theDbProvider = timesTenPlugInDatabaseImpl;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new TimesTenBundleGenerator(dBObjectProvider);
    }

    public Map getValidators(DBObjectProvider dBObjectProvider) {
        Map map = super.getValidators(dBObjectProvider);
        map.put("SEQUENCE", new SequenceValidator(dBObjectProvider));
        map.put("PACKAGE", new PackageValidator(dBObjectProvider));
        map.put("PROCEDURE", new PlSqlValidator(dBObjectProvider));
        map.put("FUNCTION", new PlSqlValidator(dBObjectProvider));
        map.put("INDEX", new TTIndexValidator(dBObjectProvider));
        return map;
    }

    public Collection<String> listPreferredDataTypeNames() {
        ArrayList<String> arrayList = new ArrayList<String>(16);
        arrayList.addAll(DEFAULT_PREFERRED_DATETYPES);
        DataSheet dataSheet = DataSheet.getInstance();
        Connection connection = this.theDbProvider == null ? null : this.theDbProvider.getConnection();
        boolean bl = false;
        if (connection == null) {
            if (dataSheet.isClientCapable(DataSheet.FeatureType.LobSupport)) {
                bl = true;
            }
        } else if (dataSheet.isCapable(connection, DataSheet.FeatureType.LobSupport)) {
            bl = true;
        }
        if (bl) {
            arrayList.add("BLOB");
            arrayList.add("CLOB");
            arrayList.add("NCLOB");
        }
        return arrayList;
    }

    static {
        DEFAULT_PREFERRED_DATETYPES.add("VARCHAR2");
        DEFAULT_PREFERRED_DATETYPES.add("NUMBER");
        DEFAULT_PREFERRED_DATETYPES.add("DATE");
    }
}

