/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.xslt;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import javax.ide.extension.Extension;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.Runner;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.StarterFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.Source;
import oracle.jdeveloper.runner.xslt.XSLTStarterFactory;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.runner.xslt.XSLTArb;
import oracle.jdevimpl.runner.xslt.XSLTConfiguration;
import oracle.jdevimpl.runner.xslt.XSLTRunnerPanel;
import oracle.jdevimpl.runner.xslt.XSLTSmartDataProvider;
import oracle.jdevimpl.runner.xslt.XSLTSourceFinder;
import oracle.jdevimpl.xml.JDevXmlIntegrationUtils;

public final class XSLTRunnerAddin
implements Addin,
IdeListener {
    private static final String EXTENSION_ID = "oracle.jdeveloper.runner";
    private static final String XML_PARSER_JAR = "xmlparserv2.jar";
    private static File xsltJar;
    private static boolean firstTime;
    private static boolean firstTimeDebugging;
    public static final String CLASSNAME_XMLString = "$oracle.xml.xslt.XMLString";
    public static final String CLASSNAME_XMLNode = "$oracle.xml.xslt.XMLNode";

    public void initialize() {
        Ide.addIdeListener((IdeListener)this);
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        return true;
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        if (XSLTRunnerAddin.isXSLTDebuggingSupported()) {
            Runner runner = Runner.getRunner();
            if (runner != null) {
                runner.registerStarterFactory(JDevXmlIntegrationUtils.getInstance().getXMLSourceClass(), (StarterFactory)new XSLTStarterFactory());
                Navigable xsltRunner = new Navigable(XSLTArb.getString(5), XSLTRunnerPanel.class);
                runner.addRunConfigurationLaunchNavigable(xsltRunner);
            }
            Source.addSourceFinder(new XSLTSourceFinder());
        }
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    private static boolean supportsJDWP(String className) {
        try {
            Object result;
            Method m;
            Class<?> c = Class.forName(className);
            if (c != null && (m = c.getMethod("supportsJDWP", null)) != null && (result = m.invoke(null, null)) instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static synchronized File getXSLTJarForDebugging() {
        if (firstTime) {
            Extension ext;
            String dir = Ide.getProperty((String)"XSLTDebuggerJarDirectory");
            if (dir != null) {
                xsltJar = new File(dir, XML_PARSER_JAR);
            } else if ((XSLTRunnerAddin.supportsJDWP("oracle.xml.xslt.XSLProcessor") || XSLTRunnerAddin.supportsJDWP("oracle.xml.parser.v2.XSLProcessor")) && (ext = ExtensionRegistry.getExtensionRegistry().findExtension(EXTENSION_ID)) != null) {
                Iterator urls = ext.getClassPath().iterator();
                String xsltJarPath = "";
                while (urls.hasNext()) {
                    String jarPath = ((URI)urls.next()).getPath();
                    if (jarPath == null || !jarPath.contains(XML_PARSER_JAR)) continue;
                    xsltJarPath = jarPath;
                    break;
                }
                if (!xsltJarPath.isEmpty()) {
                    xsltJar = new File(xsltJarPath);
                }
            }
            firstTime = false;
        }
        return xsltJar;
    }

    public static boolean isXSLTDebuggingSupported() {
        return XSLTRunnerAddin.getXSLTJarForDebugging() != null;
    }

    public static String getFirstXSLTDebugOption(String port) {
        if (firstTimeDebugging) {
            firstTimeDebugging = false;
            Debugger debugger = Debugger.getDebugger();
            if (debugger != null) {
                debugger.addSmartDataProvider((SmartDataProvider)new XSLTSmartDataProvider());
            }
        }
        return "-Doracle.xml.xslt.jdwp=server=y,port=" + port;
    }

    public static String getLastXSLTDebugOption() {
        return "-debug";
    }

    public static String getXSLTPackage() {
        return "$oracle.xml.xslt";
    }

    public static String getXSLTPackage(URL url) {
        return XSLTRunnerAddin.getXSLTPackage();
    }

    public static boolean isXSLTStylesheet(DebugClassInfo clazz) {
        if (clazz != null && clazz.getLanguage() == 4) {
            String xsltPackagePlusDot = XSLTRunnerAddin.getXSLTPackage() + ".";
            String className = clazz.getName();
            if (className.startsWith(xsltPackagePlusDot) && !className.substring(xsltPackagePlusDot.length()).startsWith("XML")) {
                return true;
            }
        }
        return false;
    }

    private static String convertName(String name) {
        StringBuffer sb = new StringBuffer(name);
        int i = 0;
        block8: while (i < sb.length()) {
            if (sb.charAt(i) == '_' && i + 1 < sb.length()) {
                switch (sb.charAt(i + 1)) {
                    default: {
                        i += 2;
                        continue block8;
                    }
                    case '_': {
                        sb.replace(i, i + 2, "_");
                        ++i;
                        continue block8;
                    }
                    case 'A': {
                        sb.replace(i, i + 2, File.separator);
                        ++i;
                        continue block8;
                    }
                    case 'B': {
                        sb.replace(i, i + 2, ".");
                        ++i;
                        continue block8;
                    }
                    case 'C': {
                        sb.replace(i, i + 2, "-");
                        ++i;
                        continue block8;
                    }
                    case 'D': {
                        sb.replace(i, i + 2, " ");
                        ++i;
                        continue block8;
                    }
                    case 'E': 
                }
                sb.replace(i, i + 2, ":");
                ++i;
                continue;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getStylesheetName(DebugClassInfo clazz, boolean showFullName) {
        String classNameWithoutPackage = clazz.getNameWithoutPackage();
        String stylesheetName = XSLTRunnerAddin.convertName(classNameWithoutPackage);
        if (showFullName) {
            if (stylesheetName.length() > 2 && stylesheetName.charAt(0) == File.separatorChar && stylesheetName.charAt(2) == ':') {
                stylesheetName = stylesheetName.substring(1);
            }
        } else {
            int lastSep = stylesheetName.lastIndexOf(File.separator);
            if (lastSep != -1) {
                stylesheetName = stylesheetName.substring(lastSep + 1);
            }
        }
        return stylesheetName;
    }

    public static String getTemplateName(DebugMethodInfo method, DebugStackFrameInfo stackFrame) {
        String methodName = method.getNameWithoutClassOrSignature();
        if (methodName.startsWith("$$")) {
            DebugDataInfo matchPatternData;
            DebugVariableInfo matchPatternVariable;
            if (stackFrame != null && (matchPatternVariable = stackFrame.getVariable("$matchPattern")) != null && (matchPatternData = matchPatternVariable.getDataInfo()) instanceof DebugDataCompositeInfo) {
                String matchPattern = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)matchPatternData, false, false);
                int index = matchPattern.indexOf(34) == -1 ? 31 : 30;
                return XSLTArb.format(index, matchPattern);
            }
            return XSLTArb.format(29, methodName.substring(2));
        }
        return XSLTRunnerAddin.convertName(methodName);
    }

    public static Node getXSLTInputNode(Project project, boolean checkShow) {
        try {
            URL inputFileURL;
            XSLTConfiguration xsltConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
            if ((!checkShow || xsltConfiguration.isShowInputFile()) && (inputFileURL = xsltConfiguration.getInputFileURL()) != null) {
                return NodeFactory.findOrCreate((URL)inputFileURL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Node getXSLTOutputNode(Project project, boolean checkShow) {
        try {
            URL outputFileURL;
            XSLTConfiguration xsltConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
            if ((!checkShow || xsltConfiguration.isShowOutputFile()) && (outputFileURL = xsltConfiguration.getOutputFileURL()) != null) {
                return NodeFactory.findOrCreate((URL)outputFileURL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getXMLNodeTypeName(short type) {
        switch (type) {
            case 1: {
                return XSLTArb.getString(32);
            }
            case 2: {
                return XSLTArb.getString(33);
            }
            case 3: {
                return XSLTArb.getString(34);
            }
            case 4: {
                return XSLTArb.getString(35);
            }
            case 5: {
                return XSLTArb.getString(36);
            }
            case 6: {
                return XSLTArb.getString(37);
            }
            case 7: {
                return XSLTArb.getString(38);
            }
            case 8: {
                return XSLTArb.getString(39);
            }
            case 9: {
                return XSLTArb.getString(40);
            }
            case 10: {
                return XSLTArb.getString(41);
            }
            case 11: {
                return XSLTArb.getString(42);
            }
            case 12: {
                return XSLTArb.getString(43);
            }
        }
        return null;
    }

    public static boolean isXSLT(Node xmlNode) {
        return JDevXmlIntegrationUtils.getInstance().isXSLT(xmlNode);
    }

    static {
        firstTime = true;
        firstTimeDebugging = true;
    }
}

