/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.BitField;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessListener;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.request.ReqFullTree;
import oracle.jdevimpl.runner.uidebug.debugger.ui.ComponentTreeRenderer;
import oracle.jdevimpl.runner.uidebug.resource.UIDebugArb;

public final class ComponentTree
implements DebuggerProcessListener,
TreeSelectionListener,
PropertyChangeListener,
MouseListener,
ActionListener {
    private final DebuggerProcess _process;
    private final DefaultTreeModel _model;
    private final TreeSelectionModel _selModel;
    private JComponent _ui;
    private JTree _tree;
    private ArrayList _expandedRows;
    private JScrollPane _scrollPane;
    private Point _ptScroll;
    private JButton _butRefresh;

    public ComponentTree(DebuggerProcess process) {
        this._process = process;
        this._model = new DefaultTreeModel(process.getWindowsRoot());
        this._selModel = new DefaultTreeSelectionModel();
        this._selModel.setSelectionMode(1);
        this._selModel.addTreeSelectionListener(this);
        this._process.addSelectionListener(this);
        process.addDebuggerProcessListener(this);
    }

    public JComponent getGUI() {
        if (this._ui == null) {
            this._ui = new JPanel(new BorderLayout());
            this._scrollPane = new JScrollPane(this.getJTree());
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._butRefresh = new JButton(IdeArb.getIcon((int)389));
            this._butRefresh.setEnabled(true);
            KeyStroke refreshKey = KeyStroke.getKeyStroke(116, 0);
            this.addKey(new MyAction(this._butRefresh), refreshKey);
            String refreshTip = UIDebugArb.getString(19) + " " + KeyUtil.toString((KeyStroke)refreshKey);
            this._butRefresh.setToolTipText(refreshTip);
            this._butRefresh.addActionListener(this);
            JToolBar tb = new JToolBar();
            tb.setFloatable(false);
            tb.setRollover(true);
            tb.add(this._butRefresh);
            this._ui.add((Component)tb, "North");
            this._ui.add((Component)this._scrollPane, "Center");
            this.whenStateChanges();
        }
        return this._ui;
    }

    private void addKey(Action action, KeyStroke ks) {
        InputMap inputMap = this._ui.getInputMap(1);
        inputMap.put(ks, action);
        ActionMap actionMap = this._ui.getActionMap();
        actionMap.put(action, action);
    }

    private JTree getJTree() {
        if (this._tree == null) {
            this._tree = new JTree(this._model);
            this._tree.setToggleClickCount(999);
            this._tree.setSelectionModel(this._selModel);
            this._tree.setRootVisible(false);
            this._tree.setShowsRootHandles(true);
            this._tree.setCellRenderer(new ComponentTreeRenderer());
            this._tree.addMouseListener(this);
        }
        return this._tree;
    }

    private void recGetExpandedRows(TreePath path, ArrayList treePaths) {
        if (this._tree.isExpanded(path)) {
            treePaths.add(path);
            TreeNode parent = (TreeNode)path.getLastPathComponent();
            int n = parent.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeNode node = parent.getChildAt(i);
                TreePath newPath = path.pathByAddingChild(node);
                this.recGetExpandedRows(newPath, treePaths);
            }
        }
    }

    private void expandRows(ArrayList expand) {
        int n = expand.size();
        for (int i = 0; i < n; ++i) {
            TreePath path = (TreePath)expand.get(i);
            this._tree.expandPath(path);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object obj;
        TreePath path = e.getNewLeadSelectionPath();
        if (path != null && (obj = path.getLastPathComponent()) instanceof XComponent) {
            XComponent xComponent = (XComponent)obj;
            this._process.setSelection(xComponent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "SELECTION") {
            this.whenSelectionChanges(evt);
        }
    }

    private void whenSelectionChanges(PropertyChangeEvent evt) {
        XComponent xcomp = (XComponent)evt.getNewValue();
        this.setSelection(xcomp);
    }

    private void setSelection(XComponent xcomp) {
        if (xcomp == null) {
            this._selModel.clearSelection();
        } else {
            Object[] nodes = this._model.getPathToRoot(xcomp);
            TreePath path = new TreePath(nodes);
            this._selModel.setSelectionPath(path);
            if (this._tree != null) {
                this._tree.scrollPathToVisible(path);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showContextMenu(e.getPoint());
        } else if (e.getClickCount() == 2) {
            Object obj;
            e.consume();
            TreePath selectionPath = this._tree.getSelectionPath();
            if (selectionPath != null && (obj = selectionPath.getLastPathComponent()) instanceof XComponent) {
                XComponent xComponent = (XComponent)obj;
                xComponent.whenGoToSource();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showContextMenu(e.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showContextMenu(e.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void showContextMenu(Point pt) {
        Object obj;
        TreePath selPath = this._tree.getPathForLocation(pt.x, pt.y);
        if (selPath != null && (obj = selPath.getLastPathComponent()) instanceof XComponent) {
            this._selModel.setSelectionPath(selPath);
            XComponent xComponent = (XComponent)obj;
            JMenuItem[] items = xComponent.getMenuItems();
            JPopupMenu menu = new JPopupMenu();
            for (int i = 0; i < items.length; ++i) {
                JMenuItem item = items[i];
                if (item != null) {
                    menu.add(item);
                    continue;
                }
                menu.addSeparator();
            }
            menu.show(this.getJTree(), pt.x, pt.y);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._butRefresh) {
            ComponentTree.whenRefresh();
        }
    }

    private void myActionPerformed(MyAction action) {
        if (action._src == this._butRefresh) {
            ComponentTree.whenRefresh();
        }
    }

    private static void whenRefresh() {
        DebuggerProcess debuggerProcess = Debugger.getInstance().getActiveDebuggerProcess();
        if (debuggerProcess != null) {
            debuggerProcess.pushRequest(new ReqFullTree());
        }
    }

    @Override
    public void rootChanging(DebuggerProcessEvent event) {
        TreeNode oldRoot = (TreeNode)this._model.getRoot();
        this._expandedRows = new ArrayList(100);
        this.recGetExpandedRows(new TreePath(oldRoot), this._expandedRows);
        this._ptScroll = this._scrollPane.getViewport().getViewPosition();
    }

    @Override
    public void rootChanged(DebuggerProcessEvent event) {
        DebuggerProcess debuggerProcess = event.getSource();
        this._model.nodeStructureChanged(debuggerProcess.getWindowsRoot());
        if (this._expandedRows != null) {
            this.expandRows(this._expandedRows);
        }
        this._scrollPane.getViewport().setViewPosition(this._ptScroll);
        XComponent selection = debuggerProcess.getSelection();
        this.setSelection(selection);
    }

    @Override
    public void stateChanged(DebuggerProcessEvent event) {
        this.whenStateChanges();
    }

    private void whenStateChanges() {
        if (this._butRefresh != null) {
            boolean isPaused = BitField.isSet((int)this._process.getStateMask(), (int)2);
            boolean isActive = BitField.isSet((int)this._process.getStateMask(), (int)1);
            this._butRefresh.setEnabled(isActive && !isPaused);
        }
    }

    final class MyAction
    extends AbstractAction {
        final JComponent _src;

        MyAction(JComponent src) {
            this._src = src;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentTree.this.myActionPerformed(this);
        }
    }
}

