/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.request;

import java.io.IOException;
import java.util.ArrayList;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.Request;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;

public final class ReqFindObjectListeners
extends Request
implements Reply {
    private static final int REQUEST_TYPE = 9;
    private final int _componentID;
    private ArrayList _objectListeners;

    public ReqFindObjectListeners(int componentID) {
        super(9, true);
        this._componentID = componentID;
    }

    @Override
    public void write(DebugStream stream) throws IOException {
        super.write(stream);
        stream.writeInt(this._componentID);
    }

    @Override
    public void readReply(DebugStream stream) throws IOException {
        int nbrObjectListeners = stream.readInt();
        this._objectListeners = new ArrayList(nbrObjectListeners);
        for (int i = 0; i < nbrObjectListeners; ++i) {
            String listenerInterface = stream.readUTF();
            String listeningClass = stream.readUTF();
            Object[] pair = new Object[]{listenerInterface, listeningClass};
            this._objectListeners.add(pair);
        }
    }

    public int getListenerCount() {
        return this._objectListeners == null ? 0 : this._objectListeners.size();
    }

    public String getListenerInterface(int i) {
        return this.getListener(i, 0);
    }

    public String getListenerClass(int i) {
        return this.getListener(i, 1);
    }

    private String getListener(int i, int pos) {
        Object[] pair = (Object[])this._objectListeners.get(i);
        return (String)pair[pos];
    }
}

