/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.reply;

import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debugger.Debugger;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerProcessEvent;
import oracle.jdevimpl.runner.uidebug.debugger.model.XComponent;
import oracle.jdevimpl.runner.uidebug.debugger.reply.DefaultReply;

public final class RepFullTree
extends DefaultReply {
    private DefaultMutableTreeNode _root = new DefaultMutableTreeNode();

    public RepFullTree(int nRequestID) {
        super(nRequestID, 1);
    }

    public String toString() {
        return this.getClass().getName() + "[ID=" + this.getRequestID() + ";type=" + this.getRequestType() + "]";
    }

    @Override
    public void readReply(DebugStream stream) throws IOException {
        Debugger debugger = Debugger.getInstance();
        DebuggerProcess debuggerProcess = debugger.getActiveDebuggerProcess();
        DebuggerProcessEvent eventChanging = new DebuggerProcessEvent(debuggerProcess, 0, this._root);
        debuggerProcess.fireDebuggerProcessEvent(eventChanging);
        this._root = (DefaultMutableTreeNode)debuggerProcess.getWindowsRoot();
        int n = stream.readInt();
        for (int i = 0; i < n; ++i) {
            boolean readImage = stream.readBoolean();
            BufferedImage bufferedImage = readImage ? RepFullTree.readImage(stream) : null;
            XComponent comp = this.readComponent(stream);
            comp.setBufferedImage(bufferedImage);
            this._root.add(comp);
        }
        DebuggerProcessEvent eventChanged = new DebuggerProcessEvent(debuggerProcess, 1, this._root);
        debuggerProcess.fireDebuggerProcessEvent(eventChanged);
    }

    private static BufferedImage readImage(DebugStream stream) {
        BufferedImage image = null;
        try {
            image = stream.readImage();
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    private XComponent readComponent(DebugStream stream) throws IOException {
        int nID = stream.readInt();
        String sClassName = stream.readClass();
        boolean bVisible = stream.readBoolean();
        int x = stream.readInt();
        int y = stream.readInt();
        int nWidth = stream.readInt();
        int nHeight = stream.readInt();
        Debugger debugger = Debugger.getInstance();
        DebuggerProcess activeDebuggerProcess = debugger.getActiveDebuggerProcess();
        XComponent comp = activeDebuggerProcess.findReference(nID);
        comp.setClassName(sClassName);
        comp.setVisible(bVisible);
        comp.setBounds(x, y, nWidth, nHeight);
        comp.removeAllChildren();
        comp.removeFromParent();
        int nChilds = stream.readInt();
        for (int i = 0; i < nChilds; ++i) {
            XComponent child = this.readComponent(stream);
            comp.add(child);
        }
        return comp;
    }

    public TreeNode getRoot() {
        return this._root;
    }
}

