/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger.model;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.jdevimpl.runner.uidebug.debugger.model.Listener;

public final class Listeners {
    private ArrayList _listeners;
    private boolean _includeChilds;

    public Listeners() {
    }

    public Listeners(Object[] listeners, boolean includeChilds) {
        if (listeners != null) {
            this._listeners = new ArrayList<Object>(Arrays.asList(listeners));
        }
        this._includeChilds = includeChilds;
    }

    public Listeners(Listeners src) {
        if (src._listeners != null) {
            this._listeners = (ArrayList)src._listeners.clone();
        }
    }

    public void compare(Listeners after, ArrayList remove, ArrayList add) {
        if (this._includeChilds != after._includeChilds) {
            if (this._listeners != null) {
                remove.addAll(this._listeners);
            }
            if (after._listeners != null) {
                add.addAll(after._listeners);
            }
        } else {
            this.diffToRemove(after, remove);
            after.diffToRemove(this, add);
        }
    }

    private void diffToRemove(Listeners after, ArrayList remove) {
        int n = this.getListenerCount();
        for (int i = 0; i < n; ++i) {
            Listener listener = this.getListener(i);
            if (after.hasListener(listener)) continue;
            remove.add(listener);
        }
    }

    public void addListener(Listener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList(1);
        }
        this._listeners.add(l);
    }

    public void removeListener(Listener l) {
        this._listeners.remove(l);
    }

    public void removeListener(int listenerID) {
        int n = this._listeners.size();
        for (int i = 0; i < n; ++i) {
            Listener listener = (Listener)this._listeners.get(i);
            if (listener.getId() != listenerID) continue;
            this._listeners.remove(i);
            break;
        }
    }

    public int getListenerCount() {
        return this._listeners == null ? 0 : this._listeners.size();
    }

    public Listener getListener(int i) {
        return (Listener)this._listeners.get(i);
    }

    private boolean hasListener(Listener l) {
        return this._listeners != null && this._listeners.contains(l);
    }

    public boolean isIncludeChilds() {
        return this._includeChilds;
    }

    public void setIncludeChilds(boolean includeChilds) {
        this._includeChilds = includeChilds;
    }
}

