/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.ReplyListener;
import oracle.jdevimpl.runner.uidebug.debugger.reply.Reply;

public final class ReceiveQueue {
    private final ArrayList _listeners = new ArrayList();

    public void addReplyListener(ReplyListener l) {
        this._listeners.add(l);
    }

    public void removeReplyListener(ReplyListener l) {
        this._listeners.remove(l);
    }

    void fireReplyEvent(final Reply reply) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReceiveQueue.this.fireReplyEvent(reply);
                }
            });
        } else {
            ReplyEvent event = new ReplyEvent();
            event.setReply(reply);
            int n = this._listeners.size();
            for (int i = 0; i < n; ++i) {
                ReplyListener l = (ReplyListener)this._listeners.get(i);
                l.replyReceived(event);
            }
        }
    }
}

