/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debugger;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.jdevimpl.runner.uidebug.debugger.DebuggerProcess;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerEvent;
import oracle.jdevimpl.runner.uidebug.debugger.events.DebuggerListener;

public final class Debugger {
    private static Debugger INSTANCE;
    private final ArrayList _processListeners = new ArrayList();
    private final ArrayList _debugProcesses = new ArrayList(1);
    private DebuggerProcess _activeDebugProcess;

    private Debugger() {
    }

    public static Debugger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Debugger();
        }
        return INSTANCE;
    }

    static void startUIDebugger(Context context) {
        DebuggerProcess debuggerProcess = new DebuggerProcess(context);
        debuggerProcess.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDebuggerProcessCount() {
        ArrayList arrayList = this._debugProcesses;
        synchronized (arrayList) {
            return this._debugProcesses.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerProcess getDebuggerProcess(int i) {
        ArrayList arrayList = this._debugProcesses;
        synchronized (arrayList) {
            return (DebuggerProcess)this._debugProcesses.get(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebugProcess(DebuggerProcess dbgProcess) {
        ArrayList arrayList = this._debugProcesses;
        synchronized (arrayList) {
            this._debugProcesses.add(dbgProcess);
        }
        this.fireDebuggerListenerEvent(0, dbgProcess);
        this.setActiveDebugger(dbgProcess);
    }

    public void removeDebugProcess(DebuggerProcess dbgProcess) {
        this.fireDebuggerListenerEvent(1, dbgProcess);
        this._debugProcesses.remove(dbgProcess);
        DebuggerProcess newActive = this._debugProcesses.size() == 0 ? null : (DebuggerProcess)this._debugProcesses.get(0);
        this.setActiveDebugger(newActive);
    }

    private void setActiveDebugger(DebuggerProcess debugger) {
        this._activeDebugProcess = debugger;
        this.fireDebuggerListenerEvent(2, this._activeDebugProcess);
    }

    public DebuggerProcess getActiveDebuggerProcess() {
        return this._activeDebugProcess;
    }

    public void addDebuggerListener(DebuggerListener l) {
        this._processListeners.add(l);
    }

    public void removeDebuggerListener(DebuggerListener l) {
        this._processListeners.remove(l);
    }

    private void fireDebuggerListenerEvent(final int eventID, final DebuggerProcess debuggerProcess) {
        if (SwingUtilities.isEventDispatchThread()) {
            DebuggerEvent e = null;
            int n = this._processListeners.size();
            for (int i = 0; i < n; ++i) {
                DebuggerListener l = (DebuggerListener)this._processListeners.get(i);
                if (e == null) {
                    e = new DebuggerEvent(eventID, debuggerProcess);
                }
                try {
                    switch (e.getEventID()) {
                        case 2: {
                            l.debuggerProcessActivated(e);
                            break;
                        }
                        case 0: {
                            l.debuggerProcessCreated(e);
                            break;
                        }
                        case 1: {
                            l.debuggerProcessDied(e);
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Debugger.this.fireDebuggerListenerEvent(eventID, debuggerProcess);
                }
            });
        }
    }
}

