/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.dialogs.ClassPackageListBrowser;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.JDebugger;

class TracingPanel
extends JPanel
implements ActionListener {
    JLabel tracingIncludeLabel = new JLabel();
    JTextField tracingIncludeTextField = new JTextField();
    JButton tracingIncludeButton = new JButton();
    JLabel tracingExcludeLabel = new JLabel();
    JTextField tracingExcludeTextField = new JTextField();
    JButton tracingExcludeButton = new JButton();

    public TracingPanel() {
        this(false);
    }

    private TracingPanel(boolean standAloneDialog) {
        ResourceUtils.resLabel((JLabel)this.tracingIncludeLabel, (Component)this.tracingIncludeTextField, (String)DbgArb.getString(759));
        ResourceUtils.resButton((AbstractButton)this.tracingIncludeButton, (String)DbgArb.getString(760));
        this.tracingIncludeButton.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.tracingExcludeLabel, (Component)this.tracingExcludeTextField, (String)DbgArb.getString(762));
        ResourceUtils.resButton((AbstractButton)this.tracingExcludeButton, (String)DbgArb.getString(763));
        this.tracingExcludeButton.addActionListener(this);
        if (Ide.getActiveProject() == null) {
            this.tracingIncludeButton.setEnabled(false);
            this.tracingExcludeButton.setEnabled(false);
        }
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add((Component)this.tracingIncludeLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.tracingIncludeTextField, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tracingIncludeButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.tracingExcludeLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 0), 0, 0));
        this.add((Component)this.tracingExcludeTextField, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tracingExcludeButton, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        if (standAloneDialog) {
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    void loadFrom(DebugConfiguration debugConfiguration) {
        this.tracingIncludeTextField.setText(debugConfiguration.getTracingInclude());
        this.tracingIncludeTextField.setSelectionStart(0);
        this.tracingIncludeTextField.setSelectionEnd(0);
        this.tracingExcludeTextField.setText(debugConfiguration.getTracingExclude());
        this.tracingExcludeTextField.setSelectionStart(0);
        this.tracingExcludeTextField.setSelectionEnd(0);
    }

    void commitTo(DebugConfiguration debugConfiguration) {
        debugConfiguration.setTracingInclude(this.tracingIncludeTextField.getText());
        debugConfiguration.setTracingExclude(this.tracingExcludeTextField.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.tracingIncludeButton) {
            String title = DbgArb.getString(761);
            String helpId = "f1_deb_traceinclude_editdialog_html";
            String s = this.tracingIncludeTextField.getText();
            ArrayList list = new ArrayList();
            IdeUtil.string2List((String)s, list);
            if (ClassPackageListBrowser.browseClassPackageList((Component)this, (String)title, (Project)Ide.getActiveProject(), (boolean)true, (boolean)true, list, (String)helpId)) {
                s = IdeUtil.list2String(list);
                this.tracingIncludeTextField.setText(s);
                this.tracingIncludeTextField.setSelectionStart(0);
                this.tracingIncludeTextField.setSelectionEnd(0);
            }
        } else if (source == this.tracingExcludeButton) {
            String title = DbgArb.getString(764);
            String helpId = "f1_deb_traceexclue_editdialog_html";
            String s = this.tracingExcludeTextField.getText();
            ArrayList list = new ArrayList();
            IdeUtil.string2List((String)s, list);
            if (ClassPackageListBrowser.browseClassPackageList((Component)this, (String)title, (Project)Ide.getActiveProject(), (boolean)true, (boolean)true, list, (String)helpId)) {
                s = IdeUtil.list2String(list);
                this.tracingExcludeTextField.setText(s);
                this.tracingExcludeTextField.setSelectionStart(0);
                this.tracingExcludeTextField.setSelectionEnd(0);
            }
        }
    }

    public static boolean showTracingDialog(DebugConfiguration debugConfiguration) {
        TracingPanel tracingPanel = new TracingPanel(true);
        String title = DbgArb.getString(765);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)tracingPanel, (Component)tracingPanel.tracingIncludeTextField, (String)title);
        tracingPanel.loadFrom(debugConfiguration);
        HelpSystem.getHelpSystem().registerTopic((JComponent)tracingPanel, "f1_deb_tracedialog_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            tracingPanel.commitTo(debugConfiguration);
            JDebugger.getInstance().tracingChanged();
            return true;
        }
        return false;
    }
}

