/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.ThreadsPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettings;

public final class ThreadsWindowSettingsPanel
extends DefaultTraversablePanel {
    ThreadsPanelSettingsPanel threadsPanel = new ThreadsPanelSettingsPanel();
    JCheckBox showThreadGroupStructureCheckBox = new JCheckBox();
    JLabel spacerLabel = new JLabel();

    public ThreadsWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_threadswindowsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.showThreadGroupStructureCheckBox, (String)DbgArb.getString(707));
        this.spacerLabel.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        Insets borderInsets = new Insets(0, 0, 0, 0);
        this.add(this.threadsPanel.makeChooseColumnsPanel(borderInsets), constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        this.add(this.makeMiscPanel(borderInsets), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add(this.spacerLabel, constraints);
    }

    private JPanel makeMiscPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 1, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        panel.add(this.showThreadGroupStructureCheckBox);
        return panel;
    }

    private ThreadsWindowSettings getData(TraversableContext tc) {
        return ThreadsWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        ThreadsWindowSettings settings = this.getData(tc);
        this.threadsPanel.onEntry(settings.getThreadsPanelSettings());
        this.showThreadGroupStructureCheckBox.setSelected(settings.isShowThreadGroupStructure());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ThreadsWindowSettings settings = this.getData(tc);
        this.threadsPanel.onExit(settings.getThreadsPanelSettings());
        settings.setShowThreadGroupStructure(this.showThreadGroupStructureCheckBox.isSelected());
    }
}

