/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.runner.debug.ClassesPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ObjectPreferences;

final class ObjectPreferencesPanel
extends ClassesPanel {
    private final ObjectPreferences objectPreferences;
    private final Map valueExpressions;
    private final List valueExpressionSuggestions;
    private final Map expandExpressions;
    private final List expandExpressionSuggestions;
    private final Set hideAllFields;
    private final Map hiddenFields;
    private final boolean sortFields;
    private final Map declaredFields;
    private final List hiddenFieldsList;
    private final JRadioButton radioValueToString;
    private final JRadioButton radioValueExpression;
    private final DefaultComboBoxModel valueExpressionModel;
    private final JComboBox valueExpressionComboBox;
    private final JTextField valueExpressionComboBoxEditor;
    private final JTextField valueExpressionTextField;
    private final JCheckBox checkExpandExpression;
    private final DefaultComboBoxModel expandExpressionModel;
    private final JComboBox expandExpressionComboBox;
    private final JTextField expandExpressionComboBoxEditor;
    private final JTextField expandExpressionTextField;
    private final JCheckBox checkExpandFields;
    private final JLabel fieldsLabel;
    private final Shuttle shuttle;
    private final JLabel fromLabel;
    private final DefaultListModel fromModel;
    private final JList fromList;
    private final JLabel fromFieldDescriptionLabel;
    private final JLabel toLabel;
    private final DefaultListModel toModel;
    private final JList toList;
    private final JLabel toFieldDescriptionLabel;
    private static final String toStringExpression = "toString()";
    private static final String fieldDescriptionLabelBlank = " ";

    static boolean showObjectPreferencesDialog(DebugClassInfo clazz, boolean sortFields) {
        JDebugger jdebugger = JDebugger.getInstance();
        ObjectPreferences objectPreferences = jdebugger.getObjectPreferences();
        TreeMap cloneValueExpressions = objectPreferences.deepCloneValueExpressions();
        TreeMap cloneExpandExpressions = objectPreferences.deepCloneExpandExpressions();
        TreeSet cloneHideAllFields = objectPreferences.deepCloneHideAllFields();
        TreeMap cloneHiddenFields = objectPreferences.deepCloneHiddenFields();
        boolean hiddenFieldsBefore = !cloneHiddenFields.isEmpty();
        ObjectPreferencesPanel panel = new ObjectPreferencesPanel(clazz, objectPreferences, cloneValueExpressions, cloneExpandExpressions, cloneHideAllFields, cloneHiddenFields, sortFields);
        String title = DbgArb.getString(774);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getInitialFocus(), (String)title);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_edit_filters_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            boolean hiddenFieldsAfter;
            DebugClassInfo currentClass = panel.getCurrentClass();
            if (currentClass != null) {
                panel.saveBody(currentClass);
            }
            objectPreferences.setChangedValueExpressions(cloneValueExpressions);
            objectPreferences.setChangedExpandExpressions(cloneExpandExpressions);
            objectPreferences.setChangedHideAllFields(cloneHideAllFields);
            objectPreferences.setChangedHiddenFields(cloneHiddenFields);
            boolean bl = hiddenFieldsAfter = !cloneHiddenFields.isEmpty();
            if (hiddenFieldsBefore != hiddenFieldsAfter) {
                jdebugger.setUseFilters(hiddenFieldsAfter);
            } else {
                jdebugger.updateDataWindows();
            }
            return true;
        }
        return false;
    }

    private ObjectPreferencesPanel(DebugClassInfo clazz, ObjectPreferences objectPreferences, Map valueExpressions, Map expandExpressions, Set hideAllFields, Map hiddenFields, boolean sortFields) {
        this.objectPreferences = objectPreferences;
        this.valueExpressions = valueExpressions;
        this.valueExpressionSuggestions = new ArrayList();
        this.expandExpressions = expandExpressions;
        this.expandExpressionSuggestions = new ArrayList();
        this.hideAllFields = hideAllFields;
        this.hiddenFields = hiddenFields;
        this.sortFields = sortFields;
        this.declaredFields = new HashMap();
        this.hiddenFieldsList = new ArrayList();
        this.radioValueToString = new JRadioButton();
        this.radioValueExpression = new JRadioButton();
        this.valueExpressionModel = new DefaultComboBoxModel();
        this.valueExpressionComboBox = new JComboBox(this.valueExpressionModel);
        this.valueExpressionComboBox.setEditable(true);
        this.valueExpressionComboBoxEditor = (JTextField)this.valueExpressionComboBox.getEditor().getEditorComponent();
        this.valueExpressionTextField = new JTextField();
        this.valueExpressionTextField.setVisible(false);
        this.checkExpandExpression = new JCheckBox();
        this.expandExpressionModel = new DefaultComboBoxModel();
        this.expandExpressionComboBox = new JComboBox(this.expandExpressionModel);
        this.expandExpressionComboBox.setEditable(true);
        this.expandExpressionComboBoxEditor = (JTextField)this.expandExpressionComboBox.getEditor().getEditorComponent();
        this.expandExpressionTextField = new JTextField();
        this.expandExpressionTextField.setVisible(false);
        this.checkExpandFields = new JCheckBox();
        this.fieldsLabel = new JLabel(DbgArb.getString(782));
        this.shuttle = new Shuttle();
        this.fromLabel = new JLabel();
        this.fromModel = new DefaultListModel();
        this.fromList = new JList();
        this.toLabel = new JLabel();
        this.toModel = new DefaultListModel();
        this.toList = new JList();
        this.fromFieldDescriptionLabel = new JLabel(fieldDescriptionLabelBlank);
        this.toFieldDescriptionLabel = new JLabel(fieldDescriptionLabelBlank);
        this.createPanel(clazz);
    }

    @Override
    protected void setSelectedClass(ComboBoxModel classModel) {
        int size = classModel.getSize();
        for (int i = 0; i < size; ++i) {
            ClassesPanel.ClassComboBoxItem item = (ClassesPanel.ClassComboBoxItem)classModel.getElementAt(i);
            if (!item.isSpecial()) continue;
            classModel.setSelectedItem(item);
            return;
        }
        super.setSelectedClass(classModel);
    }

    @Override
    protected ClassesPanel.ClassComboBoxItem createClassComboBoxItem(DebugClassInfo clazz, int row) {
        final String className = clazz.getName();
        return new ClassesPanel.ClassComboBoxItem(clazz, row){

            @Override
            protected boolean isSpecial() {
                if (ObjectPreferencesPanel.this.valueExpressions.containsKey(className)) {
                    return true;
                }
                if (ObjectPreferencesPanel.this.expandExpressions.containsKey(className)) {
                    return true;
                }
                if (ObjectPreferencesPanel.this.hideAllFields.contains(className)) {
                    return true;
                }
                return ObjectPreferencesPanel.this.hiddenFields.containsKey(className);
            }
        };
    }

    @Override
    JPanel createBody() {
        JLabel infoLabel = new JLabel(DbgArb.getString(775));
        JLabel valueLabel = new JLabel(DbgArb.getString(776));
        ResourceUtils.resButton((AbstractButton)this.radioValueToString, (String)DbgArb.getString(777));
        ResourceUtils.resButton((AbstractButton)this.radioValueExpression, (String)DbgArb.getString(778));
        ButtonGroup buttonGroupValue = new ButtonGroup();
        buttonGroupValue.add(this.radioValueToString);
        buttonGroupValue.add(this.radioValueExpression);
        this.valueExpressionComboBoxEditor.getAccessibleContext().setAccessibleName(this.radioValueExpression.getText());
        this.valueExpressionTextField.getAccessibleContext().setAccessibleName(this.radioValueExpression.getText());
        JLabel expandLabel = new JLabel(DbgArb.getString(779));
        ResourceUtils.resButton((AbstractButton)this.checkExpandExpression, (String)DbgArb.getString(780));
        this.expandExpressionComboBoxEditor.getAccessibleContext().setAccessibleName(this.checkExpandExpression.getText());
        this.expandExpressionTextField.getAccessibleContext().setAccessibleName(this.checkExpandExpression.getText());
        ResourceUtils.resButton((AbstractButton)this.checkExpandFields, (String)DbgArb.getString(781));
        ResourceUtils.resLabel((JLabel)this.fromLabel, (Component)this.fromList, (String)DbgArb.getString(783));
        this.shuttle.add((Component)this.fromLabel, (Object)"FromHeader");
        this.fromList.setModel(this.fromModel);
        ListPicker fromPicker = new ListPicker(this.fromList);
        fromPicker.setItemsSorted(this.sortFields);
        this.shuttle.setFromPicker((ItemPicker)fromPicker);
        this.shuttle.add((Component)this.fromFieldDescriptionLabel, (Object)"FromFooter");
        ResourceUtils.resLabel((JLabel)this.toLabel, (Component)this.toList, (String)DbgArb.getString(784));
        this.shuttle.add((Component)this.toLabel, (Object)"ToHeader");
        this.toList.setModel(this.toModel);
        ListPicker toPicker = new ListPicker(this.toList);
        toPicker.setItemsSorted(this.sortFields);
        this.shuttle.setToPicker((ItemPicker)toPicker);
        this.shuttle.add((Component)this.toFieldDescriptionLabel, (Object)"ToFooter");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int y = 0;
        panel.add((Component)infoLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)valueLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.radioValueToString, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.radioValueExpression, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.valueExpressionComboBox, new GridBagConstraints(1, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.valueExpressionTextField, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)expandLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.checkExpandExpression, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.expandExpressionComboBox, new GridBagConstraints(1, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.expandExpressionTextField, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.checkExpandFields, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.fieldsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 30, 0, 0), 0, 0));
        panel.add((Component)this.shuttle, new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 30, 0, 0), 0, 0));
        ActionListener actionListenerRadioValue = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPreferencesPanel.this.enableValueSection();
            }
        };
        this.radioValueToString.addActionListener(actionListenerRadioValue);
        this.radioValueExpression.addActionListener(actionListenerRadioValue);
        this.valueExpressionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = (String)ObjectPreferencesPanel.this.valueExpressionComboBox.getSelectedItem();
                ObjectPreferencesPanel.this.valueExpressionComboBoxEditor.setText(s);
                ObjectPreferencesPanel.this.valueExpressionTextField.setText(s);
            }
        });
        this.checkExpandExpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPreferencesPanel.this.enableExpandSection();
            }
        });
        this.expandExpressionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = (String)ObjectPreferencesPanel.this.expandExpressionComboBox.getSelectedItem();
                ObjectPreferencesPanel.this.expandExpressionComboBoxEditor.setText(s);
                ObjectPreferencesPanel.this.expandExpressionTextField.setText(s);
            }
        });
        this.checkExpandFields.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPreferencesPanel.this.enableHiddenFieldsSection();
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ObjectPreferencesPanel.this.updateFieldDescriptionLabel((JList)e.getSource());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        this.fromList.addFocusListener(focusListener);
        this.toList.addFocusListener(focusListener);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ObjectPreferencesPanel.this.updateFieldDescriptionLabel((JList)e.getSource());
            }
        };
        this.fromList.addListSelectionListener(listSelectionListener);
        this.toList.addListSelectionListener(listSelectionListener);
        return panel;
    }

    @Override
    Dimension getAppropriateSize() {
        return new Dimension(575, 400);
    }

    @Override
    void saveBody(DebugClassInfo currentClass) {
        String className = currentClass.getName();
        if (this.radioValueToString.isSelected()) {
            this.valueExpressions.put(className, toStringExpression);
        } else {
            String valueExpression = this.valueExpressionTextField.getText();
            if (valueExpression.length() > 0) {
                this.valueExpressions.put(className, valueExpression);
                this.objectPreferences.addChangedValueExpressionSuggestion(className, valueExpression);
            } else {
                this.valueExpressions.remove(className);
            }
        }
        if (this.checkExpandExpression.isSelected()) {
            String expandExpression = this.expandExpressionTextField.getText();
            if (expandExpression.length() > 0) {
                this.expandExpressions.put(className, expandExpression);
                this.objectPreferences.addChangedExpandExpressionSuggestion(className, expandExpression);
            } else {
                this.expandExpressions.remove(className);
            }
        } else {
            this.expandExpressions.remove(className);
        }
        if (this.checkExpandFields.isSelected()) {
            this.hideAllFields.remove(className);
        } else {
            this.hideAllFields.add(className);
        }
        int count = this.toModel.size();
        if (count > 0) {
            String[] fieldNames = new String[count];
            for (int i = 0; i < count; ++i) {
                fieldNames[i] = (String)this.toModel.elementAt(i);
            }
            this.hiddenFields.put(className, fieldNames);
        } else {
            this.hiddenFields.remove(className);
        }
    }

    @Override
    void clearBody() {
        this.radioValueExpression.setSelected(true);
        this.valueExpressionSuggestions.clear();
        this.valueExpressionSuggestions.add("");
        this.valueExpressionModel.removeAllElements();
        this.valueExpressionModel.addElement("");
        this.valueExpressionModel.setSelectedItem("");
        this.valueExpressionTextField.setText("");
        this.enableValueSection();
        this.checkExpandExpression.setSelected(false);
        this.expandExpressionSuggestions.clear();
        this.expandExpressionSuggestions.add("");
        this.expandExpressionModel.removeAllElements();
        this.expandExpressionModel.addElement("");
        this.expandExpressionModel.setSelectedItem("");
        this.expandExpressionTextField.setText("");
        this.enableExpandSection();
        this.checkExpandFields.setSelected(true);
        this.fromModel.clear();
        this.toModel.clear();
        this.declaredFields.clear();
        this.hiddenFieldsList.clear();
        this.fromFieldDescriptionLabel.setText(fieldDescriptionLabelBlank);
        this.toFieldDescriptionLabel.setText(fieldDescriptionLabelBlank);
        this.enableHiddenFieldsSection();
    }

    @Override
    void loadBody(DebugClassInfo currentClass) {
        ArrayList<String> temp;
        String expandExpression;
        String valueExpression;
        String className = currentClass.getName();
        String[] valueSuggestions = this.objectPreferences.getValueExpressionSuggestions(className);
        if (valueSuggestions != null) {
            int length = valueSuggestions.length;
            for (int i = 0; i < length; ++i) {
                this.valueExpressionSuggestions.add(valueSuggestions[i]);
                this.valueExpressionModel.addElement(valueSuggestions[i]);
            }
        }
        if ((valueExpression = (String)this.valueExpressions.get(className)) != null) {
            if (valueExpression.equals(toStringExpression)) {
                this.radioValueToString.setSelected(true);
            } else {
                if (!this.valueExpressionSuggestions.contains(valueExpression)) {
                    this.valueExpressionSuggestions.add(valueExpression);
                    this.valueExpressionModel.addElement(valueExpression);
                }
                this.valueExpressionModel.setSelectedItem(valueExpression);
            }
        }
        boolean useComboBoxForValueExpression = this.valueExpressionSuggestions.size() > 1;
        this.valueExpressionComboBox.setVisible(useComboBoxForValueExpression);
        this.valueExpressionTextField.setVisible(!useComboBoxForValueExpression);
        this.enableValueSection();
        String[] expandSuggestions = this.objectPreferences.getExpandExpressionSuggestions(className);
        if (expandSuggestions != null) {
            int length = expandSuggestions.length;
            for (int i = 0; i < length; ++i) {
                this.expandExpressionSuggestions.add(expandSuggestions[i]);
                this.expandExpressionModel.addElement(expandSuggestions[i]);
            }
        }
        if ((expandExpression = (String)this.expandExpressions.get(className)) != null && expandExpression.length() > 0) {
            this.checkExpandExpression.setSelected(true);
            if (!this.expandExpressionSuggestions.contains(expandExpression)) {
                this.expandExpressionSuggestions.add(expandExpression);
                this.expandExpressionModel.addElement(expandExpression);
            }
            this.expandExpressionModel.setSelectedItem(expandExpression);
        } else {
            this.checkExpandExpression.setSelected(false);
        }
        boolean useComboBoxForExpandExpression = this.expandExpressionSuggestions.size() > 1;
        this.expandExpressionComboBox.setVisible(useComboBoxForExpandExpression);
        this.expandExpressionTextField.setVisible(!useComboBoxForExpandExpression);
        this.enableExpandSection();
        boolean expandFields = !this.hideAllFields.contains(className);
        this.checkExpandFields.setSelected(expandFields);
        String[] fieldNames = (String[])this.hiddenFields.get(className);
        if (fieldNames != null) {
            temp = new ArrayList<String>();
            for (String fieldName : fieldNames) {
                this.hiddenFieldsList.add(fieldName);
                temp.add(fieldName);
            }
            if (this.sortFields) {
                Collections.sort(temp);
            }
            int size = temp.size();
            for (int i = 0; i < size; ++i) {
                this.toModel.addElement(temp.get(i));
            }
        }
        temp = new ArrayList();
        for (DebugFieldInfo field : currentClass.getFields(0, false, true)) {
            String fieldName = field.getName();
            this.declaredFields.put(fieldName, field);
            if (this.hiddenFieldsList.contains(fieldName)) continue;
            temp.add(fieldName);
        }
        if (this.sortFields) {
            Collections.sort(temp);
        }
        int size = temp.size();
        for (int i = 0; i < size; ++i) {
            this.fromModel.addElement(temp.get(i));
        }
    }

    private void enableValueSection() {
        boolean expressionIsSelected = this.radioValueExpression.isSelected();
        this.valueExpressionComboBox.setEnabled(expressionIsSelected);
        this.valueExpressionTextField.setEnabled(expressionIsSelected);
    }

    private void enableExpandSection() {
        boolean expressionIsSelected = this.checkExpandExpression.isSelected();
        this.expandExpressionComboBox.setEnabled(expressionIsSelected);
        this.expandExpressionTextField.setEnabled(expressionIsSelected);
    }

    private void enableHiddenFieldsSection() {
        boolean fieldsIsSelected = this.checkExpandFields.isSelected();
        this.fieldsLabel.setEnabled(fieldsIsSelected);
        this.shuttle.setEnabled(fieldsIsSelected);
        this.fromLabel.setEnabled(fieldsIsSelected);
        this.fromList.setEnabled(fieldsIsSelected);
        this.toLabel.setEnabled(fieldsIsSelected);
        this.toList.setEnabled(fieldsIsSelected);
        this.fromFieldDescriptionLabel.setEnabled(fieldsIsSelected);
        this.toFieldDescriptionLabel.setEnabled(fieldsIsSelected);
    }

    private void updateFieldDescriptionLabel(JList list) {
        JLabel fieldDescriptionLabel = list == this.fromList ? this.fromFieldDescriptionLabel : this.toFieldDescriptionLabel;
        String fieldName = (String)list.getSelectedValue();
        DebugFieldInfo field = (DebugFieldInfo)this.declaredFields.get(fieldName);
        if (field != null) {
            fieldDescriptionLabel.setText(field.getClassInfo().getName() + fieldDescriptionLabelBlank + fieldName);
        } else {
            fieldDescriptionLabel.setText(fieldDescriptionLabelBlank);
        }
    }
}

